﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Redis.Model
{
    public class RedisChangeRecordModel
    {
        public int id { get; set; }

        /// <summary>
        /// 设备编号
        /// </summary>
        public string equip_code { get; set; }

        /// <summary>
        /// 设备名称
        /// </summary>
        public string equip_name { get; set; }

        /// <summary>
        /// 刀具名称
        /// </summary>
        public string tool_name { get; set; }

        /// <summary>
        /// 刀具图纸号
        /// </summary>
        public string tool_drawno { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string tool_no { get; set; }

        /// <summary>
        /// 额定寿命
        /// </summary>
        public int? rating_life { get; set; }

        /// <summary>
        /// 新刀已使用寿命
        /// </summary>
        public int? residual_life { get; set; }

        /// <summary>
        /// 当前刀剩余寿命（换刀前）
        /// </summary>
        public int? true_residual_life { get; set; }

        /// <summary>
        /// 换刀人id
        /// </summary>
        public string change_user { get; set; }

        /// <summary>
        /// 换刀时间
        /// </summary>
        public int change_time { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string comment { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 项目ID
        /// </summary>
        public int projectid { get; set; }

        /// <summary>
        /// 主轴名称
        /// </summary>
        public string mainaxis { get; set; }

        /// <summary>
        /// 供应商名称
        /// </summary>
        public string supplier { get; set; }

        /// <summary>
        /// 设备ID
        /// </summary>
        public int machine_id { get; set; }

        /// <summary>
        /// 换刀原因
        /// </summary>
        public string change_reason { get; set; }

        /// <summary>
        /// 图片地址
        /// </summary>
        public string url_path { get; set; }

        /// <summary>
        /// 是否使用
        /// </summary>
        public string is_use { get; set; } = "1";

        /// <summary>
        /// 当前换刀程序号
        /// </summary>
        public string programno { get; set; }
    }
}
