﻿using System;
using System.Collections.Generic;
using System.Text;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.RedisEntities;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class CNCPressureTemperatureRepository : RedisRepositoryBase
    {
        private readonly bool _dispose;
        public CNCPressureTemperatureRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }

        public void Dispose()
        {
            Client?.Dispose();
        }

        /// <summary>
        /// 获取当前设备压铸信息
        /// </summary>
        /// <param name="machineId"></param>
        /// <returns></returns>
        public CNCPressureTemperature GetCncMeltingot(int machineId)
        {
            try
            {
                var data = Client.HGet(HashPressureTemperature, machineId.ToString());
                if (!string.IsNullOrEmpty(data))
                {
                    return JsonHelper.DeserializerJsonResult<CNCPressureTemperature>(data);
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
            return null;
        }

        /// <summary>
        /// 获取所有设备压铸信息
        /// </summary>
        /// <returns></returns>
        public IEnumerable<CNCPressureTemperature> GetCncPressureTemperatures(IEnumerable<int> machineIds)
        {
            var result = new List<CNCPressureTemperature>();
            try
            {
                foreach (var machineId in machineIds)
                {
                    var data = Client.HGet(HashPressureTemperature, machineId.ToString());
                    if (!string.IsNullOrEmpty(data))
                    {
                        var obj = JsonHelper.DeserializerJsonResult<CNCPressureTemperature>(data);
                        result.Add(obj);
                    }
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
            return result;
        }
    }
}
