﻿using System;
using System.Collections.Generic;
using System.Text;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.RedisEntities;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class MouldUsageDataRepository : RedisRepositoryBase
    {
        public MouldUsageDataRepository(int companyId, int projectId) : base(companyId, projectId)
        {
        }

        public void Dispose()
        {
            Client?.Dispose();
        }

        /// <summary>
        /// 获取模具压模次数
        /// </summary>
        /// <param name="mould"></param>
        /// <returns></returns>
        public int GetMouldUsage(string mould)
        {
            try
            {
                var data = Client.HGet(HashMouldUsageData, mould);
                if (!string.IsNullOrEmpty(data))
                {
                    var usage = JsonHelper.DeserializerJsonResult<MouldUsageData>(data);

                    return usage.usage;
                }

                return 0;
            }
            catch
            {
                return 0;
            }
            finally
            {
                Dispose();
            }
        }
    }
}
