﻿using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.RedisEntities;
using Siger.Middlelayer.Redis.Utility;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class ToolCycleSortingRepository: RedisRepositoryBase
    {
        private bool _dispose;

        public ToolCycleSortingRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }
        public void Dispose()
        {
            Client?.Dispose();
        }
        public ToolCycleSort GetSequence(int machineId,string processPn)
        {
            //redis 

            var filed = $"{machineId}_{processPn}";

            try
            {
                var data = Client.HGet(HashTMSToolSequence, filed);
                if (!string.IsNullOrEmpty(data))
                {
                    return JsonHelper.DeserializerJsonResult<ToolCycleSort>(data);
                }
            }
            catch (Exception e)
            {
                throw e;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
            return null;
        }

        public ToolCycleSort BConfig(int machineId,string processPn)
        {
            var filed = $"{machineId}_{processPn}";
        
            try
            {
                var data = Client.HGet(TMSToolCycleSortConfig, filed);
                if (!string.IsNullOrEmpty(data))
                {
                    return JsonHelper.DeserializerJsonResult<ToolCycleSort>(data);

                }
            }
            catch (Exception e)
            {
                throw e;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
            return null;
        }
        public void UpdateSeq(ToolCycleSort cycleSort, int machine,string processPn)
        {
            try
            {
                var key = $"{machine}_{processPn}";
                var jsData = JsonHelper.SerializerToJsonString(cycleSort);
                Client.HSet(TMSToolCycleSortConfig, key, jsData);
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }
    }
}
