using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.DependencyInjection;
using Siger.ApiCommon.Filters;
using Siger.ApiCommon.Utilities;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.TpmRepository;
using Siger.Middlelayer.Log;
using Xunit;
using Siger.ApiTPM.Controllers;
using Siger.Middlelayer.TpmRepository.Repositories.Interface;
using Siger.Middlelayer.Repository;
using Siger.ApiCommon;
using Siger.Middlelayer.TpmRepository.Request;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Repository.Repositories.Interface;
using System.Linq;
using System;
using System.Collections.Generic;
using Siger.Middlelayer.Share.Models;

namespace Siger.Unit.Test.TPM
{
    public class MessagePushTest
    {
        private readonly DependencyInjectionTest DependencyInjection = new DependencyInjectionTest();
        private readonly ISigerAppProjectConfigRepository _appProjectConfigRepository;
        private readonly ApiTpmDbContext _context;
        private readonly IUnitOfWork _unitOfWork;
        private readonly int pid = 1458;
        public MessagePushTest()
        {
            var services = DependencyInjection.Init();
            _unitOfWork = services.GetService<IUnitOfWork>();
            _appProjectConfigRepository = services.GetService<ISigerAppProjectConfigRepository>();
            _context = services.GetService<ApiTpmDbContext>();
        }

        [Fact]
        public void GetAppConfig()
        {
            var configs = _appProjectConfigRepository.GetList(f => f.projectId == pid && f.status == 1).ToList();
            Assert.True(configs.Count > 0);
        }

        [Fact]
        public void PushMessage()
        {
            var mid = 1927;
            var config = _appProjectConfigRepository.Get(f => f.projectId == pid && f.status == 1);
            var pushhelper = new MessageJPushHelper(config.appkey, config.appsecret, config.signid, config.issendSMS);
            var isOnline = IsOnlie(mid, pid, SystemConfigKey.AppUserOnlineInterval);
            var user=_context.siger_project_user.FirstOrDefault(f => f.mid == mid && f.projectid == pid);
            var appUser = _context.siger_app_project_user.FirstOrDefault(f => f.mid == mid && f.projectId == pid);
            var templateId = 166005;
            var paras = new Dictionary<string, string>
                        {
                            { "location",  ""},
                        };
            var messageInfo = new PushMessage
            {
                tomid = user.mid,
                projectid = pid,
                repairid = 0,
                create_time = UnixTimeHelper.GetTodayUnix(),
                type = 2,
                title = "test",
                content =" test push Kpi info",
                read_sign = 0,
                status = (int)RowState.Valid,
            };
            var result= pushhelper.PushMessage(messageInfo, isOnline, appUser.appkey, user.mobile, templateId, paras);
            Assert.True(result==PushMessageResult.SendSuccessful);

        }

        private bool IsOnlie(int mid, int projectId, string key)
        {
            var intervalMinutes = 5;
            var config =
                _context.siger_system_config.FirstOrDefault(q => q.key == key && q.status == (int)RowState.Valid);
            if (config != null)
            {
                var interval = config.value.ToInt();
                if (interval > 0)
                {
                    intervalMinutes = interval;
                }
            }

            var entity = _context.siger_app_project_user.FirstOrDefault(q =>
                q.projectId == projectId && q.mid == mid && q.status == (int)RowState.Valid);
            if (entity != null)
            {
                if (entity.refresh_time != null)
                {
                    if (DateTime.Now.Subtract(entity.refresh_time.Value).TotalMinutes <= intervalMinutes)
                    {
                        return true;
                    }
                }

                return false;
            }

            return false;
        }
    }
}
