import Vue from 'vue'
import Router from 'vue-router'
import routes from './routers'
import store from '@/store'
import iView from 'iview'

import {
  setToken,
  getToken,
  canTurnTo,
  setTitle
} from '@/libs/util'

const originalPush = Router.prototype.push
Router.prototype.push = function push(location) {
  return originalPush.call(this, location).catch(err => err)
}
const originalReplace = Router.prototype.replace
Router.prototype.replace = function replace(location) {
  return originalReplace.call(this, location).catch(err => err)
}

Vue.use(Router)
const router = new Router({
  routes,
  // 本地环境
  // mode: 'history'
  // 测试环境
  mode: 'hash'
})
const LOGIN_PAGE_NAME = 'login'

const turnTo = (to, access, next) => {
  // 进入的路由的 name access 数组 路由对象
  if (canTurnTo(to.name, access, routes)) next() // 有权限，可访问
  else {
    // 为啥这边不加限制呢？验证了下上面的 canTurnTo 方法没达到预期效果
    next(function () {})
  } // 无权限，重定向到401页面
  // else next({ replace: true, name: 'error_401' }) // 无权限，重定向到401页面
}

router.beforeEach((to, from, next) => {
  if (to.path == '/audit/') {
    setToken('')
    next()
  } else if (to.path.indexOf('mtsSearch') > 0) {
    // 追溯查询页面
    setToken('')
    next()
  } else if (to.path.indexOf('terminal') != -1) {
    // 操作终端页面
    next()
  } else {
    iView.LoadingBar.start()
    // 从 Cookie 中取到 Token
    const token = getToken()
    if (!token && to.name !== LOGIN_PAGE_NAME) {
      // 未登录且要跳转的页面不是登录页
      next({
        name: LOGIN_PAGE_NAME // 跳转到登录页
      })
    } else if (!token && to.name === LOGIN_PAGE_NAME) {
      // 未登陆且要跳转的页面是登录页
      next() // 跳转到登录页
    } else if (token && to.name === LOGIN_PAGE_NAME) {
      setToken('')
      // 已登录且要跳转的页面是登录页
      next({
        name: LOGIN_PAGE_NAME // 跳转到登录页
      })
    } else {
      // 根据 vuex 中 user.hasGetInfo 这个字段判断是否已经获取到用户信息了，vuex 中的数据刷新之后就丢失了，所以每次刷新页面后，都会走下面的逻辑获取一次用户信息，但是不刷新页面，vuex 中的数据不会丢失，就都会走上面的逻辑直接判断是否有权限跳转路由了
      // 如果已经获取到用户信息，直接走路由跳转权限判断逻辑
      if (store.state.user.hasGetInfo) {
        turnTo(to, store.state.user.access, next)
      } // 如果未获取到用于信息， 
      else {
        store.dispatch('getUserInfo').then(user => {
          // 拉取用户信息，通过用户权限和跳转的页面的name来判断是否有权限访问;access必须是一个数组，如：['super_admin'] ['super_admin', 'admin']
          turnTo(to, user.access, next)
        }).catch(() => {
          setToken('')
          next({
            name: LOGIN_PAGE_NAME
          })
        })
      }
    }
  }
})

router.afterEach(to => {
  setTitle(to, router.app)
  iView.LoadingBar.finish()
  window.scrollTo(0, 0)
})

export default router
