﻿using System;
using System.Collections.Generic;
using System.Linq.Expressions;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Extensions;
using System.Linq;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.ApiACC.Controllers
{
    public class AutomationLocationController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly IAutomationFixtureToolsCategoryRepository _toolsCategoryRepository;
        private readonly IAutomationFixtureToolsRepository _toolsRepository;
        private readonly IAutomationLocationRepository _autoLocationRepository;
        private readonly ISigerTrMaterialsRepository _materialsRepository;

        public AutomationLocationController(IUnitOfWork unitOfWork, IAutomationFixtureToolsCategoryRepository toolsCategoryRepository, 
            IAutomationFixtureToolsRepository toolsRepository, IAutomationLocationRepository autoLocationRepository, 
            ISigerTrMaterialsRepository materialsRepository)
        {
            _unitOfWork = unitOfWork;
            _toolsCategoryRepository = toolsCategoryRepository;
            _toolsRepository = toolsRepository;
            _autoLocationRepository = autoLocationRepository;
            _materialsRepository = materialsRepository;
        }

        public IActionResult GetPageList(string wavehouseid, string locationid, int page, int pagesize)
        {
            var data = _autoLocationRepository.GetPagedList(wavehouseid.ToInt(), locationid.ToInt(), ProjectId, page, pagesize);
            return new PagedObjectResult(data.Data, data.Total, page, pagesize);
        }

        [HttpPost]
        public IActionResult Add([FromBody]RequestAddAutomationLocation req)
        {
            if (string.IsNullOrEmpty(req.locationid) || string.IsNullOrEmpty(req.fixturetoolid) || string.IsNullOrEmpty(req.materialid))
            {
                throw new BadRequestException(RequestEnum.ParameterMiss);
            }
            var fixturetool = _toolsRepository.Get(q => q.id == req.fixturetoolid.ToInt() && q.projectId == ProjectId);
            if (fixturetool == null)
            {
                throw new BadRequestException(RequestEnum.FixtureToolNotFound);
            }
            var location = _autoLocationRepository.GetLocation(req.locationid.ToInt(), ProjectId);
            if (location == null)
            {
                throw new BadRequestException(RequestEnum.LocationNull);
            }
            var material = _materialsRepository.Get(q => q.id == req.materialid.ToInt() && q.projectId == ProjectId && q.status == (int)RowState.Valid);
            var data = _autoLocationRepository.Get(q => q.projectId == ProjectId && q.status == (int)RowState.Valid && q.fixturetools == fixturetool.guid &&
                q.locationid == req.locationid.ToInt());
            if (data != null)
            {
                throw new BadRequestException(RequestEnum.DataExist);
            }

            var state = 1;
            if (fixturetool != null && material == null)
            {
                state = 1;//有工装 无工件
            }
            else if(fixturetool != null && material != null)
            {
                state = 2;//有工装 有工件
            }
            else if (fixturetool == null && material == null)
            {
                state = 3;//无工装 无工件
            }
            else if (fixturetool == null && material != null)
            {
                state = 4;//无工装 有工件
            }
            var entity = new siger_automation_location
            {
                guid = Guid.NewGuid().ToString(),
                locationid = req.locationid.ToInt(),
                fixturetools = fixturetool.guid,
                materialid = req.materialid.ToInt(),
                processid = req.processid.ToInt(),
                materialstate = state,
                attachment = req.fileurl,
                filename = req.filename,
                remark = req.remark,
                projectId = ProjectId,
                updatetime = DateTime.Now,
                updator = UserId,
            };
            _autoLocationRepository.Insert(entity);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        [HttpPost]
        public IActionResult Update([FromBody]RequestUpdateAutomationLocation req)
        {
            if (string.IsNullOrEmpty(req.locationid) || string.IsNullOrEmpty(req.fixturetoolid) || string.IsNullOrEmpty(req.materialid))
            {
                throw new BadRequestException(RequestEnum.ParameterMiss);
            }
            var entity = _autoLocationRepository.Get(q => q.id == req.id && q.projectId == ProjectId && q.status == (int)RowState.Valid);
            var fixturetool = _toolsRepository.Get(q => q.id == req.fixturetoolid.ToInt() && q.projectId == ProjectId);
            if (fixturetool == null)
            {
                throw new BadRequestException(RequestEnum.FixtureToolNotFound);
            }
            var location = _autoLocationRepository.GetLocation(req.locationid.ToInt(), ProjectId);
            if (location == null)
            {
                throw new BadRequestException(RequestEnum.LocationNull);
            }
            var material = _materialsRepository.Get(q => q.id == req.materialid.ToInt() && q.projectId == ProjectId && q.status == (int)RowState.Valid);
            var data = _autoLocationRepository.Get(q => q.projectId == ProjectId && q.status == (int)RowState.Valid && q.fixturetools == fixturetool.guid &&
                q.locationid == req.locationid.ToInt() && q.id != req.id);
            if (data != null)
            {
                throw new BadRequestException(RequestEnum.DataExist);
            }

            var state = 1;
            if (fixturetool != null && material == null)
            {
                state = 1;//有工装 无工件
            }
            else if (fixturetool != null && material != null)
            {
                state = 2;//有工装 有工件
            }
            else if (fixturetool == null && material == null)
            {
                state = 3;//无工装 无工件
            }
            else if (fixturetool == null && material != null)
            {
                state = 4;//无工装 有工件
            }
            entity.locationid = req.locationid.ToInt();
            entity.fixturetools = fixturetool.guid;
            entity.materialid = req.materialid.ToInt();
            entity.processid = req.processid.ToInt();
            entity.materialstate = state;
            entity.attachment = req.fileurl;
            entity.filename = req.filename;
            entity.remark = req.remark;
            entity.updatetime = DateTime.Now;
            entity.updator = UserId;
            _autoLocationRepository.Update(entity);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        [HttpGet]
        public IActionResult Delete(int id)
        {
            var entity = _autoLocationRepository.Get(q => q.projectId == ProjectId && q.status == (int)RowState.Valid && q.id == id);
            if (entity == null)
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }

            entity.status = (int)RowState.Invalid;
            _autoLocationRepository.Update(entity);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        [HttpPost]
        public IActionResult Deletes([FromBody]RequestDeleteRange req)
        {
            if (req.ids == null || !req.ids.Any())
            {
                throw new BadRequestException(RequestEnum.ParameterMiss);
            }
            var entities = _autoLocationRepository.GetList(t =>
                req.ids.Contains(t.id) && t.projectId == ProjectId && t.status == (int)RowState.Valid).ToList();
            if (!entities.Any())
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }
            foreach (var entity in entities)
            {
                entity.status = (int)RowState.Invalid;
                _autoLocationRepository.Update(entity);
            }

            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            throw new BadRequestException(CommonEnum.Fail);
        }
    }
}
