﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.Share.Constant;
using Siger.Middlelayer.Share.Enum.ModuleEnum;

namespace Siger.ApiACC.Controllers
{

    public class AutomationOperateController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly ISigerProjectLevelSectionRepository _sigerProjectLevelSection;
        private readonly ISigerDict _sigerDict;
        private readonly IAutomationMachineStatus _automationMachineStatus;
        private readonly ISigerProjectMachineAttributionRepository _sigerProjectMachineAttribution;

        public AutomationOperateController(IUnitOfWork unitOfWork,ISigerProjectLevelSectionRepository sigerProjectLevelSection , ISigerDict sigerDict,IAutomationMachineStatus  automationMachineStatus,ISigerProjectMachineAttributionRepository sigerProjectMachineAttribution)
        {
            _unitOfWork = unitOfWork;
            _sigerProjectLevelSection = sigerProjectLevelSection;
            _sigerDict = sigerDict;
            _automationMachineStatus = automationMachineStatus;
            _sigerProjectMachineAttribution = sigerProjectMachineAttribution;
        }

        public IActionResult Get()
        {
            return new ObjectResult(1);
        }

        /// <summary>
        /// 获取字典配置 
        /// </summary>
        /// <param name="line">产线</param>
        /// <param name="type">类型：0：上料  1：检验</param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetloadStation(int line,int type)
        {
            var stationDicts = _sigerDict.GetDataByCat(AccDictCost.Automation, ProjectId);
            if (!stationDicts.Any())
            {
                Logger.WriteLineInfo($"GetloadStation 未配置设备类型字典");
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }

            var loadStation=new List<string>();

            if (type==0)
            {
                var dictLoad = stationDicts.Where(s => s.dkey == DictKeyValConst.UploadloadStation);
                if (!dictLoad.Any())
                {
                    Logger.WriteLineInfo($"GetloadStation 未配置上下料工站字典");
                    throw new BadRequestException(CommonEnum.RecordNotFound);
                }
                loadStation = dictLoad.Select(s => s.dval).ToList();
            }else
            {
                var dictLoad = stationDicts.Where(s => s.dkey == DictKeyValConst.CleanStation);
                if (!dictLoad.Any())
                {
                    Logger.WriteLineInfo($"GetloadStation 未配置清洗工站字典");
                    throw new BadRequestException(CommonEnum.RecordNotFound);
                }
                loadStation = dictLoad.Select(s => s.dval).ToList();
            }
           

            var data = new List<ResponseLoadStation>();

            foreach (var station in loadStation)
            {
                var section = _sigerProjectLevelSection.Get(f => f.id == station.ToInt() && f.parentid==line && f.status == (int)RowState.Valid);
                if (section == null)
                    continue;
                var machintAttr = _sigerProjectMachineAttribution.Get(f => f.station == section.id);
                if(machintAttr==null)
                {
                    Logger.WriteLineInfo($"GetloadStation 未配置清洗工站字典");
                    continue;
                }
                var loadStatus = (int)Automation.MachineStatus.Waiting;
                var machineStatus = _automationMachineStatus.Get(f => f.section == station.ToInt() && f.status==(int)RowState.Valid);
                if (machineStatus==null)
                {
                    _automationMachineStatus.Insert(new siger_automation_machine_status
                    {
                         projectId=ProjectId,
                         enable=1,
                         machineid=machintAttr.machine,
                         section=section.id,
                         updatetime=DateTime.Now
                    });
                }else
                {
                    loadStatus = machineStatus.status;
                }
                data.Add(new ResponseLoadStation { 
                 section=section.id,
                 title=section.title,
                 status=loadStatus
                });
            }
            return new ObjectResult(data);
        }

        /// <summary>
        /// 准备上料
        /// </summary>
        /// <param name="loading"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Loading([FromBody]requestAutomationLoading loading)
        {
            var data = new ResponseAutomationInfo {
                sn="sn0001",
                wo="wo123123"
            };
            return new ObjectResult(data);
        }

        /// <summary>
        /// 安装完成
        /// </summary>
        /// <param name="assemble"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult CompalateAssemble([FromBody]requestAutoCompalateAssemble assemble)
        {
            return new ObjectResult(1);
        }
        /// <summary>
        /// 准备下料
        /// </summary>
        /// <param name="unloading"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Unloading([FromBody]requestAutomationUnloading unloading)
        {

            return new ObjectResult(1);
        }

        /// <summary>
        /// 拆卸完成
        /// </summary>
        /// <param name="disassemble"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Disassemble([FromBody]Requestdisassemble disassemble)
        {

            return new ObjectResult(1);
        }
    }
}
