﻿using System;
using System.Collections.Generic;
using System.Linq.Expressions;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Extensions;
using System.Linq;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.ApiACC.Controllers
{
    public class FixtureToolsAssemblyController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly IAutomationFixtureToolsCategoryRepository _toolsCategoryRepository;
        private readonly IAutomationFixtureToolsRepository _toolsRepository;
        private readonly IAutomationFixtureToolsAssemblyRepository _toolsAssemblyRepository;

        public FixtureToolsAssemblyController(IUnitOfWork unitOfWork, IAutomationFixtureToolsCategoryRepository toolsCategoryRepository, 
            IAutomationFixtureToolsRepository toolsRepository, IAutomationFixtureToolsAssemblyRepository toolsAssemblyRepository)
        {
            _unitOfWork = unitOfWork;
            _toolsCategoryRepository = toolsCategoryRepository;
            _toolsRepository = toolsRepository;
            _toolsAssemblyRepository = toolsAssemblyRepository;
        }

        [HttpGet]
        public IActionResult GetPageList(string category, string code, string name, int projectid, int page, int pagesize)
        {
            var data = _toolsAssemblyRepository.GetPagedList(category.ToInt(), code, name, ProjectId, page, pagesize);
            return new PagedObjectResult(data.Data, data.Total, page, pagesize);
        }

        [HttpGet]
        public IActionResult GetDetail(string id)
        {
            var data = _toolsAssemblyRepository.GetDetailList(id.ToInt(), ProjectId);

            return new ObjectResult(data);
        }

        [HttpPost]
        public IActionResult Add([FromBody]RequestAddFixtureToolAssembly req)
        {
            if (string.IsNullOrEmpty(req.fixturetoolid))
            {
                throw new BadRequestException(RequestEnum.ParameterMiss);
            }
            var parent = _toolsRepository.Get(q => q.id == req.parentid.ToInt() && q.projectId == ProjectId);
            var son = _toolsRepository.Get(q => q.id == req.fixturetoolid.ToInt() && q.projectId == ProjectId);
            if (son == null)
            {
                throw new BadRequestException(RequestEnum.FixtureToolNotFound);
            }
            if (parent == null)
            {
                
            }
            var parentGuid = parent?.guid ?? "";
            var exsit = _toolsAssemblyRepository.Get(q => q.projectId == ProjectId && q.son == son.guid && q.parent == parentGuid);
            if (exsit != null)
            {
                throw new BadRequestException(RequestEnum.DataExist);
            }

            var entity = new siger_automation_fixture_tools_assembly
            {
                guid = Guid.NewGuid().ToString(),
                parent = parent?.guid ?? "",
                son = son.guid,
                creator = UserId,
                createtime = DateTime.Now,
                attachment = req.fileurl,
                filename = req.filename,
                projectId = ProjectId,
                updatetime = DateTime.Now,
                updator = UserId,
                status = req.status.ToInt() == (int)RowState.Valid ? (int)RowState.Valid : (int)RowState.Invalid,
            };
            _toolsAssemblyRepository.Insert(entity);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        [HttpPost]
        public IActionResult Update([FromBody]RequestUpdateFixtureToolAssembly req)
        {
            if (string.IsNullOrEmpty(req.fixturetoolid))
            {
                throw new BadRequestException(RequestEnum.ParameterMiss);
            }
            var entity = _toolsAssemblyRepository.Get(q => q.projectId == ProjectId && q.id == req.id);
            if(entity == null)
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }
            var parent = _toolsRepository.Get(q => q.id == req.parentid.ToInt() && q.projectId == ProjectId);
            var son = _toolsRepository.Get(q => q.id == req.fixturetoolid.ToInt() && q.projectId == ProjectId);
            if (son == null)
            {
                throw new BadRequestException(RequestEnum.FixtureToolNotFound);
            }
            var parentGuid = parent?.guid ?? "";
            var exsit = _toolsAssemblyRepository.Get(q => q.projectId == ProjectId && q.son == son.guid && q.parent == parentGuid &&
                q.id != req.id);
            if (exsit != null)
            {
                throw new BadRequestException(RequestEnum.DataExist);
            }

            entity.parent = parent?.guid ?? "";
            entity.son = son.guid;
            entity.attachment = req.fileurl;
            entity.filename = req.filename;
            entity.updatetime = DateTime.Now;
            entity.updator = UserId;
            entity.status = req.status.ToInt() == (int)RowState.Valid ? (int)RowState.Valid : (int)RowState.Invalid;
            _toolsAssemblyRepository.Update(entity);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        [HttpGet]
        public IActionResult Delete(int id)
        {
            var entity = _toolsRepository.Get(q => q.projectId == ProjectId && q.id == id);
            if (entity == null)
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }
            _toolsAssemblyRepository.Delete(entity);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        [HttpPost]
        public IActionResult Deletes([FromBody]RequestDeleteRange req)
        {
            if (req.ids == null || !req.ids.Any())
            {
                throw new BadRequestException(RequestEnum.ParameterMiss);
            }
            var entities = _toolsAssemblyRepository.GetList(t => req.ids.Contains(t.id) && t.projectId == ProjectId).ToList();
            if (!entities.Any())
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }
            foreach (var entity in entities)
            {
                _toolsAssemblyRepository.Delete(entity);
            }

            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            throw new BadRequestException(CommonEnum.Fail);
        }
    }
}
