﻿using System;
using System.Collections.Generic;
using System.Linq.Expressions;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Extensions;
using System.Linq;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.ApiACC.Controllers
{
    public class FixtureToolsProductController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly IAutomationFixtureToolsCategoryRepository _toolsCategoryRepository;
        private readonly IAutomationFixtureToolsRepository _toolsRepository;
        private readonly IAutomationFixtureToolsProductRepository _toolsProductRepository;
        private readonly ISigerProjectProductRepository _productRepository;

        public FixtureToolsProductController(IUnitOfWork unitOfWork, IAutomationFixtureToolsCategoryRepository toolsCategoryRepository, 
            IAutomationFixtureToolsRepository toolsRepository, IAutomationFixtureToolsProductRepository toolsProductRepository,
            ISigerProjectProductRepository productRepository)
        {
            _unitOfWork = unitOfWork;
            _toolsCategoryRepository = toolsCategoryRepository;
            _toolsRepository = toolsRepository;
            _toolsProductRepository = toolsProductRepository;
            _productRepository = productRepository;
        }

        public IActionResult GetPageList(string category, string tool, string product, int page, int pagesize)
        {
            var data = _toolsProductRepository.GetPagedList(category.ToInt(), tool.ToInt(), product.ToInt(), ProjectId, page, pagesize);
            return new PagedObjectResult(data.Data, data.Total, page, pagesize);
        }

        [HttpPost]
        public IActionResult Add([FromBody]RequestAddFixtureToolsProduct req)
        {
            if(string.IsNullOrEmpty(req.fixturetoolid) || string.IsNullOrEmpty(req.productid))
            {
                throw new BadRequestException(RequestEnum.ParameterMiss);
            }
            var fixtureTool = _toolsRepository.Get(q => q.projectId == ProjectId && q.id == req.fixturetoolid.ToInt());
            if(fixtureTool == null)
            {
                throw new BadRequestException(RequestEnum.FixtureToolNotFound);
            }
            var product = _productRepository.Get(q => q.projectid == ProjectId && q.status == (int)RowState.Valid && q.id == req.productid.ToInt());
            if(product == null)
            {
                throw new BadRequestException(RequestEnum.ProductNotFound);
            }
            var data = _toolsProductRepository.Get(q => q.projectId == ProjectId && q.status == (int)RowState.Valid && (q.fixturetools == fixtureTool.guid ||
                q.productid == req.productid.ToInt()));
            if (data != null)
            {
                throw new BadRequestException(RequestEnum.DataExist);
            }

            var entity = new siger_automation_fixture_tools_product
            {
                guid = Guid.NewGuid().ToString(),
                fixturetools = fixtureTool.guid,
                remark=req.remark,
                productid=req.productid.ToInt(),
                projectId = ProjectId,
                createtime = DateTime.Now,
                updatetime = DateTime.Now,
                creator = UserId,
                updator = UserId,
            };
            _toolsProductRepository.Insert(entity);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        [HttpPost]
        public IActionResult Update([FromBody]RequestUpdateFixtureToolsProduct req)
        {
            if (string.IsNullOrEmpty(req.fixturetoolid) || string.IsNullOrEmpty(req.productid))
            {
                throw new BadRequestException(RequestEnum.ParameterMiss);
            }
            var entity = _toolsProductRepository.Get(q => q.projectId == ProjectId && q.status == (int)RowState.Valid && q.id == req.id);
            if(entity == null)
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }
            var fixtureTool = _toolsRepository.Get(q => q.projectId == ProjectId && q.id == req.fixturetoolid.ToInt());
            if (fixtureTool == null)
            {
                throw new BadRequestException(RequestEnum.FixtureToolNotFound);
            }
            var product = _productRepository.Get(q => q.projectid == ProjectId && q.status == (int)RowState.Valid && q.id == req.productid.ToInt());
            if (product == null)
            {
                throw new BadRequestException(RequestEnum.ProductNotFound);
            }
            var data = _toolsProductRepository.Get(q => q.projectId == ProjectId && q.status == (int)RowState.Valid && (q.fixturetools == fixtureTool.guid ||
                q.productid == req.productid.ToInt()) && q.id != req.id);
            if (data != null)
            {
                throw new BadRequestException(RequestEnum.DataExist);
            }

            entity.fixturetools = fixtureTool.guid;
            entity.remark = req.remark;
            entity.productid = req.productid.ToInt();
            entity.updatetime = DateTime.Now;
            entity.updator = UserId;
            _toolsProductRepository.Insert(entity);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        [HttpGet]
        public IActionResult Delete(int id)
        {
            var entity = _toolsProductRepository.Get(q => q.projectId == ProjectId && q.status == (int)RowState.Valid && q.id == id);
            if (entity == null)
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }

            entity.status = (int)RowState.Invalid;
            _toolsProductRepository.Update(entity);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        [HttpPost]
        public IActionResult Deletes([FromBody]RequestDeleteRange req)
        {
            if (req.ids == null || !req.ids.Any())
            {
                throw new BadRequestException(RequestEnum.ParameterMiss);
            }
            var entities = _toolsProductRepository.GetList(t =>
                req.ids.Contains(t.id) && t.projectId == ProjectId && t.status == (int)RowState.Valid).ToList();
            if (!entities.Any())
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }
            foreach (var entity in entities)
            {
                entity.status = (int)RowState.Invalid;
                _toolsProductRepository.Update(entity);
            }

            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            throw new BadRequestException(CommonEnum.Fail);
        }
    }
}
