﻿using Siger.Middlelayer.AccRepository;
using Siger.Middlelayer.CncRepository;
using Siger.Middlelayer.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiACC.Tasks
{
    public class DBhelper 
    {
        private static DBhelper _helper;
        public static DBhelper Instance = _helper ?? (_helper = new DBhelper());

        public ApiCncDbContext CncDbContext;
        public ApiAccDbContext AccDbContext;
        public ApiConfigDbContext ConfigDbContext;

        static DBhelper()
        {
        }
        public void LoadDbContext()
        {
            CncDbContext = new ApiCncDbContext();
            AccDbContext = new ApiAccDbContext();
            ConfigDbContext = new ApiConfigDbContext();
        }

        public List<int> GetTaskList()
        {
            return new List<int>();
        }
        public void Dispose()
        {
            CncDbContext?.Dispose();
            AccDbContext?.Dispose();
            ConfigDbContext?.Dispose();
        }
    }
}
