﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Request;

namespace Siger.ApiConfig.Controller
{
    public class FrequencyController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly ISigerProjectConfigFrequencyRepository _configFrequencyRepository;
        private readonly ISigerProjectUserRepository _userRepository;
        private readonly ISigerProjectShiftRepository _sigerProjectShiftRepository;
        public FrequencyController(ISigerProjectConfigFrequencyRepository configFrequencyRepository, IUnitOfWork unitOfWork,
            ISigerProjectUserRepository userRepository, ISigerProjectShiftRepository sigerProjectShiftRepository)
        {
            _configFrequencyRepository = configFrequencyRepository;
            _unitOfWork = unitOfWork;
            _userRepository = userRepository;
            _sigerProjectShiftRepository = sigerProjectShiftRepository;
        }


        /// <summary>
        /// 班次 增
        /// </summary>
        /// <param name="ret"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult FrequencyAdd([FromBody] RequestFrequency ret)
        {
            if (ret != null)
            {
                var frequency = _configFrequencyRepository.GetList(q =>q.projectid == ProjectId && q.status == (int)RowState.Valid);
                if (frequency.Any())
                {
                    throw new BadRequestException(RequestEnum.AlreadyExists);
                }
                var result = new siger_project_config_frequency()
                {
                    name = ret.name,
                    train=ret.train,
                    describe=ret.describe,
                    addTime = DateTime.Now,
                    uid = UserId.ToString(),
                    projectid = ProjectId
                };
                _configFrequencyRepository.Insert(result);
                if (_unitOfWork.Commit() > 0)
                {
                    return new ObjectResult(CommonEnum.Succefull);
                }
                throw new BadRequestException(CommonEnum.Fail);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }

        /// <summary>
        /// 班次 删
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult FrequencyDelete(int id)
        {
            var rest = _configFrequencyRepository.Get(q => q.id >= id && q.projectid == ProjectId && q.status == (int)RowState.Valid);
            if (rest != null)
            {
                rest.status = (int)RowState.Invalid;
                _configFrequencyRepository.Update(rest);
            }
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }

        /// <summary>
        /// 班次 改
        /// </summary>
        /// <param name="ret"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult FrequencyUpdate([FromBody] RequestUpdateFrequency ret)
        {
            if (ret != null)
            {
                var rest = _configFrequencyRepository.Get(q => q.id >= ret.id && q.projectid == ProjectId && q.status == (int)RowState.Valid);
                if (rest != null)
                {
                    rest.name = ret.name;
                    rest.train = ret.train;
                    rest.describe = ret.describe;
                    _configFrequencyRepository.Update(rest);
                }
                if (_unitOfWork.Commit() > 0)
                {
                    return new ObjectResult(CommonEnum.Succefull);
                }
                throw new BadRequestException(CommonEnum.Fail);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }

        /// <summary>
        /// 班次 查
        /// </summary>
        /// <param name="page"></param>
        /// <param name="pageSige"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult FrequencySelect()
        {
            var restList = new List<RequestRestTypees>();
            var result = _configFrequencyRepository.GetList(q=>q.status == (int)RowState.Valid && q.projectid == ProjectId).ToList();
            if (result.Any())
            {
                foreach (var item in result)
                {
                    var rest = new RequestRestTypees();
                    var strList = item.train.Split(',');
                    if (strList.Length>0)
                    {
                        var train = "";
                        for (int i = 0; i < strList.Length; i++)
                        {
                            var frequency = _sigerProjectShiftRepository.Get(q => q.id.ToString() == strList[i] && q.status == (int)RowState.Valid && q.projectid == ProjectId);
                            if (frequency!=null)
                            {
                                if (i == 0)
                                {
                                    train = frequency.title+"："+UnixTimeHelper.GetTimeByUnix(frequency.start_time)+"--"+UnixTimeHelper.GetTimeByUnix(frequency.end_time);
                                }
                                else
                                {
                                    train += ","+ frequency.title + "："+UnixTimeHelper.GetTimeByUnix(frequency.start_time)+"--"+UnixTimeHelper.GetTimeByUnix(frequency.end_time);
                                }
                                
                            }
                        }
                        rest.train = train;
                        rest.train1 = item.train;
                    }
                    var users = _userRepository.Get(q => q.mid.ToString() == item.uid && q.status == (int)RowState.Valid && q.projectid == ProjectId);
                    if (users != null)
                    {
                        rest.uid = users.name;
                    }
                    rest.name = item.name;
                    rest.addTime = item.addTime;
                    rest.describe = item.describe;
                    restList.Add(rest);
                }
            }
            return new ObjectResult(restList);
        }

      
    }
}
