﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiDashboard.Result
{
    public class QualityDashboardResult : CncResultBase
    {
      
    }

    public class GetIncomingCheckResult
    {
        public int Qualified { get; set; }

        public double QualifiedRate { get; set; }

        public int Rework { get; set; }

        public double ReworkRate { get; set; }

        public int Reception { get; set; }

        public double ReceptionRate { get; set; }

        public int Rejection { get; set; }

        public double RejectionRate { get; set; }

        public int Total { get; set; }

        public double TotalRate { get; set; }

        public int Defect { get; set; }

        public double DefectRate { get; set; }

        public List<SupplierDetail> details { get; set; } = new List<SupplierDetail>();
    }

    public class SupplierDetail
    {
        public string name { get; set; }

        public string batchnumber { get; set; }

        public int total { get; set; }

        public int random { get; set; }
    }

    public class GetCheckStationStatusResult : QualityDashboardResult
    {
        public List<CheckStationList> data = new List<CheckStationList>();
    }

    public class CheckStationList
    {
        public string Channel { get; set; }

        public List<CheckSectionStatus> CheckSections = new List<CheckSectionStatus>();
    }

    public class CheckSectionStatus
    {
        public string section { get; set; }

        public int status { get; set; }
    }

    public class GetTestRoomCheckStatusResult
    {
        public int Qualified { get; set; }

        public double QualifiedRate { get; set; }

        public int DeviationRelease { get; set; }

        public double DeviationReleaseRate { get; set; }

        public int UnQualified { get; set; }

        public double UnQualifiedRate { get; set; }

        public int Compeleted { get; set; }

        public double CompeletedRate { get; set; }

        public int Testing { get; set; }

        public double TestingRate { get; set; }

        public int Recieved { get; set; }

        public double RecievedRate { get; set; }

        public int Checking { get; set; }

        public double CheckingRate { get; set; }
    }

    public class GetChannelFtqResult
    {
        public List<string> X { get; set; } = new List<string>();

        public List<double> Y { get; set; } = new List<double>();
        /// <summary>
        /// 合格率
        /// </summary>
        public double totalFtq { get; set; }
    }

    public class GetFailureDataResult
    {
        public List<string> X { get; set; } = new List<string>();

        public List<int> unhandles { get; set; } = new List<int>();

        public List<int> handlings { get; set; } = new List<int>();

        public List<int> handles { get; set; } = new List<int>();

        public int total { get; set; }

        public int unhandle { get; set; }

        public int handling { get; set; }

        public int handle { get; set; }
    }
}
