﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Infrastructure;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository.Request;
using Siger.Middlelayer.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiQMS.Controllers
{
    public class WorkCellCfgController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly IQmscellCfgRepository _qmscellCfg;

        public WorkCellCfgController(IUnitOfWork unitOfWork, IQmscellCfgRepository qmscellCfg)
        {
            _unitOfWork = unitOfWork;
            _qmscellCfg = qmscellCfg;
        }

        [HttpGet]
        public IActionResult Getlist(int page,int pageSize)
        {
            var data = _qmscellCfg.GetPagedList(page, pageSize, f => f.projectid == ProjectId, "id");
            return new PagedLongTotalObjectResult(data.Data, data.Total, page, pageSize);
        }
        [HttpGet]
        public IActionResult GetCellItem()
        {
            var data = _qmscellCfg.GetList(f => f.projectid == ProjectId);
            return new ObjectResult(data);
        }
        [HttpPost]
        public IActionResult Add([FromBody]RequestCellCfg request)
        {
            if (_qmscellCfg.IsExist(f=>f.projectid==ProjectId && f.cell==request.cell))
                throw new BadRequestException(CommonEnum.RecordExits);

            _qmscellCfg.Insert(new Middlelayer.QmsRepository.Entities.siger_qms_cell_cfg
            {
                projectid = ProjectId,
                cell = request.cell,
                status = (int)RowState.Valid
            });
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            throw new BadRequestException(CommonEnum.Fail);
        }

        [HttpPost]
        public IActionResult Modify([FromBody]RequestCellCfg request)
        {
            var objCellCfg = _qmscellCfg.Get(f => f.projectid == ProjectId && f.id == request.id);

            if (objCellCfg==null)
                throw new BadRequestException(CommonEnum.RecordNotFound);
            objCellCfg.cell = request.cell;
            _qmscellCfg.Update(objCellCfg);
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            throw new BadRequestException(CommonEnum.Fail);
        }
        [HttpPost]
        public IActionResult Del([FromBody]RequestIds request)
        {
            if (!request.ids.Any())
                throw new BadRequestException(RequestEnum.ParameterMiss);
            foreach (var id in request.ids)
            {
                var obj = _qmscellCfg.Get(f => f.id == id);
                if (obj == null)
                    throw new BadRequestException(CommonEnum.RecordNotFound);
                _qmscellCfg.Delete(obj);
            }
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            throw new BadRequestException(CommonEnum.Fail);
        }
    }
}
