﻿using Siger.ApiCommon.Result;
using System.Collections.Generic;

namespace Siger.ApiQMS.Result
{
    public class RuleTraceData
    {
        public int itemID { get; set; }

        public double UCL { get; set; }

        public double LCL { get; set; }

        public long traceID { get; set; }

        public List<long> traceDetailID { get; set; } = new List<long>();

        public List<double> value { get; set; } = new List<double>();
    }
    /// <summary>
    /// 请求判异方法
    /// </summary>
    public class RequestQMSDynamicDiag
    {
        public int itemID { get; set; }

        public double UCL { get; set; }

        public double LCL { get; set; }
        public long traceID { get; set; }
        public string value { get; set; }
        public int rule1 { get; set; }
        public int rule2 { get; set; }
        public int rule3 { get; set; }
        public int rule4 { get; set; }
        public int rule5 { get; set; }
        public int rule6 { get; set; }
        public int rule7 { get; set; }
        public int rule8 { get; set; }
    }

    public class ResponseQMSDynamicDiag
    {
        public long traceID { get; set; }
        public int? rule1 { get; set; }
        public int? rule2 { get; set; }
        public int? rule3 { get; set; }
        public int? rule4 { get; set; }
        public int? rule5 { get; set; }
        public int? rule6 { get; set; }
        public int? rule7 { get; set; }
        public int? rule8 { get; set; }
    }
    /// <summary>
    /// 请求CPK直方图
    /// </summary>
    public class RequestQmsDynamicHistParams
    {
        public int itemID { get; set; }

        public double UCL { get; set; }

        public double LCL { get; set; }

        public string value { get; set; }
    }

    public class ReponseQmsDynamicHistParams
    {
        public int? SampleSize { get; set; }

        public double? SampleMean { get; set; }

        public double? SampleStd { get; set; }

        public double? UpperLimit { get; set; }

        public double? LowerLimit { get; set; }

        public double? MidLine { get; set; }

        public double? Cp { get; set; }

        public double? Cpk { get; set; }

        public double? Cpu { get; set; }

        public double? Cpl { get; set; }
    }

    public class SpcCheckResData
    {
        public List<long> ids { get; set; } = new List<long>();
        public int ItemID { get; set; }
        public string abnomal_status { get; set; }
    }
}
