﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.ApiCommon.Utilities;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.AppSettings;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Dapper;
using Siger.Middlelayer.Repository.Request;
using Siger.Middlelayer.ToolRepository.Repositories.Interface;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.ToolRepository.Request;
using Siger.Middlelayer.ToolRepository.Response;
using Siger.Middlelayer.Utility.Helpers;
using Siger.Middlelayer.Utility.ImportEntities;
using Siger.ApiCommon.Filters;
namespace Siger.ApiTools.Controllers
{
    public class ToolConfigController : BaseController
    {
        private readonly ISigerProjectToolCutterLocationTrueRepository _sigerProjectToolCutterLocationTrueRepository;
        private readonly ISigerToolChangeRecordRepository _sigerToolChangeRecordRepository;

        public ToolConfigController(ISigerProjectToolCutterLocationTrueRepository sigerProjectToolCutterLocationTrueRepository, ISigerToolChangeRecordRepository sigerToolChangeRecordRepository)
        {
            _sigerProjectToolCutterLocationTrueRepository = sigerProjectToolCutterLocationTrueRepository;
            _sigerToolChangeRecordRepository = sigerToolChangeRecordRepository;
        }
        [HttpGet]
        public IActionResult GetMachineListByFilter(string machinefilter,int count)
        {
            var data = _sigerProjectToolCutterLocationTrueRepository.GetMachineList(machinefilter, ProjectId, count);
            return new ObjectResult(data);
        }

        [HttpGet]
        public IActionResult GetProductList(string productfilter, int count)
        {
            var data = _sigerProjectToolCutterLocationTrueRepository.GetProductList(productfilter, ProjectId, count);
            return new ObjectResult(data);
        }

        [HttpGet]
        public IActionResult GetToolList(int sectionid, string tooltype, string toolfilter, string brand, int count)
        {
            var data = _sigerProjectToolCutterLocationTrueRepository.GetToolList(sectionid, ProjectId, tooltype, toolfilter, brand, count);
            return new ObjectResult(data);
        }

        [HttpPost]
        public IActionResult ToolList([FromBody]RequestToolList request)
        {
            var data = _sigerProjectToolCutterLocationTrueRepository.GetToolList(request, ProjectId);
            return new ObjectResult(data);
        }

        [HttpPost]
        public ActionResult ToolLifeReport([FromBody] RequestToolLifeReport req)
        {
            var toolName = req.tooltype.ToValidParameter();
            var data = _sigerToolChangeRecordRepository.GetToolLifeReport(req.sectionid, ProjectId,
                UnixTimeHelper.GetUnixByShortDate(req.starttime),
                UnixTimeHelper.GetUnixByShortDate(req.endtime), toolName, req.toolid.ToInt());
            if (!data.Any())
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }
            var requestX = req.x.ToInt();
            var requestY = req.y.ToInt();
            var xline = new List<object>();
            var vline = new List<object>();
            var vlineTemp = new ToolLifeReportData();
            foreach (var item in data)
            {
                if (item.residual_life <= 0)
                    continue;
                var price = Math.Round(item.toolunitprice / item.residual_life, 2);
                if (requestX == 1 && requestY == 1)
                {
                    //x供应商y寿命
                    if (!string.IsNullOrEmpty(item.toolsupplier))
                    {
                        vlineTemp.Add(item.toolsupplier, item.residual_life);
                    }
                }
                else if (requestX == 2 && requestY == 1)
                {
                    //x时间y寿命
                    xline.Add(UnixTimeHelper.ConvertStringDateTime(item.change_time.ToString()).ToString("yyyy/MM/dd"));
                    vline.Add(item.residual_life);
                }
                else if (requestX == 3 && requestY == 1)
                {
                    //x刀具图纸号y寿命
                    vlineTemp.Add(item.tooldrawingcode, item.residual_life);
                }
                else if (requestX == 1 && requestY == 2)
                {
                    //x供应商y单价
                    if (!string.IsNullOrEmpty(item.toolsupplier))
                    {
                        vlineTemp.Add(item.toolsupplier, (double)price);
                    }
                }
                else if (requestX == 2 && requestY == 2)
                {
                    //x时间y单价
                    xline.Add(UnixTimeHelper.ConvertStringDateTime(item.change_time.ToString()).ToString("yyyy/MM/dd"));
                    vline.Add(price);
                }
                else if (requestX == 3 && requestY == 2)
                {
                    //x刀具图纸号y单价
                    vlineTemp.Add(item.tooldrawingcode, (double)price);
                }
            }
            if (vlineTemp.node.Count != 0)
            {
                foreach (var item in vlineTemp.node)
                {
                    var tempData = BoxPlot.CalcBoxPlot(item.value);
                    if (tempData != null)
                    {
                        vline.Add(tempData);
                        xline.Add(item.key);
                    }
                }
            }

            if (vline.Any())
            {
                return new ObjectResult(new { x = xline, v = vline });
            }

            return new ObjectResult(CommonEnum.Succefull);
        }
    }
}