﻿using System;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.WmsRepository.Repositories.Interface;
using Siger.Middlelayer.WmsRepository.Request;

namespace Siger.ApiWMS.Controllers
{
    /// <summary>
    /// 领用归还
    /// </summary>
    public class CollarUseController : BaseController
    {
        private readonly Isiger_wms_receive_useRepository storage;
        private readonly Isiger_wms_receive_useRepository use;
        private readonly IUnitOfWork _unitOfWork;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="storage"></param>
        /// <param name="use"></param>
        /// <param name="unitOfWork"></param>
        public CollarUseController(Isiger_wms_receive_useRepository storage, Isiger_wms_receive_useRepository use, IUnitOfWork unitOfWork)
        {
            this.storage = storage;
            this.use = use;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 领用归还列表
        /// </summary>
        /// <param name="type"></param>
        /// <param name="sn"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="page"></param>
        /// <param name="pageSize"></param>
        /// <returns></returns>
        public IActionResult GetCollarUesList(UseType type,string sn,DateTime start,DateTime end,int page=1, int pageSize=10)
        {
            Utility.CheckPage(page, pageSize);
            var result = storage.GetList(type,sn,start,end,ProjectId,page, pageSize, out int total);
            return new PagedObjectResult(result, total, page, pageSize);
        }
        /// <summary>
        /// 领用
        /// </summary>
        /// <param name="req"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Use([FromBody]RequestCollarUse req)
        {
            if(string.IsNullOrEmpty(req.workCode))
            {
                throw new BadRequestException(RequestEnum.WorkCodeIsEmpty);
            }
            if (string.IsNullOrEmpty(req.useAddress))
            {
                throw new BadRequestException(RequestEnum.UseAddressNotNull);
            }
            if (string.IsNullOrEmpty(req.sn))
            {
                throw new BadRequestException(RequestEnum.SNEmpty);
            }
            use.Use(req.workCode,req.useAddress,req.sn,ProjectId,UserId);
            return Ok();
        }
        /// <summary>
        /// 归还
        /// </summary>
        /// <param name="req"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult SendBack([FromBody]RequesetSendBack req)
        {
            if (string.IsNullOrEmpty(req.workCode))
            {
                throw new BadRequestException(RequestEnum.WorkCodeIsEmpty);
            }
            if (string.IsNullOrEmpty(req.sn))
            {
                throw new BadRequestException(RequestEnum.SNEmpty);
            }
            use.SendBack(req.workCode, req.locationID, req.sn, ProjectId, UserId);
            return Ok();
        }

        /// <summary>
        /// 物料列表
        /// </summary>
        /// <returns></returns>
        public IActionResult GetNameList()
        {
            var tmp = use.GetMaterialsList(ProjectId);
            var result = tmp.Select(f => new { f.id, f.name }).ToList();
            return new ObjectResult(result);
        }
    }
}