﻿using Siger.CommonUtil;
using System;
using System.Collections.Generic;
using System.IO;

namespace Siger.Middlelayer.Common.Configuration
{
    public class ConfigManager
    {
        private static IConfig _config;

        /// <summary>
        /// Construct the ConfigManager by given content.
        /// </summary>
        static ConfigManager()
        {

            if (!ConfigFactory.IsInit)
            {
                var filePath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Setting", "CommonSetting.ini");
                if (!File.Exists(filePath))
                {
                    throw new FileNotFoundException("can not found CommonSetting.ini.");
                }
                using (var reader = new StreamReader(filePath))
                {
                    var content = reader.ReadToEnd();
                    ConfigFactory.InitConfigByContent(content);
                    _config = ConfigFactory.GetConfig();
                }
            }
            else
            {
                _config = ConfigFactory.GetConfig();
            }
        }


        /// <summary>
        /// Get one item value of one section.
        /// </summary>
        /// <typeparam name="T">The type of return value.</typeparam>
        /// <param name="section">the section's name</param>
        /// <param name="key">The key's name</param>
        /// <param name="defaultValue">The default value of the T</param>
        /// <returns></returns>
        public static T GetValue<T>(string section, string key, T defaultValue)
        {
            return _config.GetSectionKeyValue<T>(section, key, defaultValue);
        }

        public static T GetSection<T>(string section)
        {
            return _config.GetSectionObj<T>(section);
        }
    }

    #region  backup code

    //public class ConfigManager
    //{
    //    private static readonly Dictionary<string, Dictionary<string, string>> _sections =
    //        new Dictionary<string, Dictionary<string, string>>();

    //    /// <summary>
    //    /// Construct the ConfigManager by given content.
    //    /// </summary>
    //    static ConfigManager()
    //    {
    //        var filePath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Setting", "CommonSetting.ini");
    //        if (!File.Exists(filePath))
    //        {
    //            throw new FileNotFoundException("can not found CommonSetting.ini.");
    //        }
    //        using (var reader = new StreamReader(filePath))
    //        {
    //            var content = reader.ReadToEnd();

    //            var sections = LoadSections(content);
    //            foreach (var section in sections)
    //            {
    //                _sections[section.Name] = new Dictionary<string, string>();

    //                foreach (var parameter in section.Items)
    //                {
    //                    _sections[section.Name][parameter.Key] = parameter.Value;
    //                }
    //            }
    //        }
    //    }

    //    /// <summary>
    //    /// Load all sections from context.
    //    /// </summary>
    //    /// <param name="content"></param>
    //    /// <returns></returns>
    //    private static List<ConfigSection> LoadSections(string content)
    //    {
    //        var configLoader = new ConfigLoader();
    //        return configLoader.LoadConfig(content);
    //    }

    //    /// <summary>
    //    /// Get one item value of one section.
    //    /// </summary>
    //    /// <typeparam name="T">The type of return value.</typeparam>
    //    /// <param name="section">the section's name</param>
    //    /// <param name="key">The key's name</param>
    //    /// <param name="defaultValue">The default value of the T</param>
    //    /// <returns></returns>
    //    public static T GetValue<T>(string section, string key, T defaultValue)
    //    {
    //        Type t = typeof(T);
    //        if (_sections.TryGetValue(section, out var sectionContent) &&
    //            sectionContent.TryGetValue(key, out var value))
    //        {
    //            if (t == typeof(string))
    //            {
    //                return (T)((object)value);
    //            }
    //            if (t == typeof(bool))
    //            {
    //                if (value == "0" || value == "1")
    //                {
    //                    return (T) ((object) (value == "1"));
    //                }

    //                if (value.ToLower() == "true" || value.ToLower() == "false")
    //                {
    //                    return (T)((object)(value == "true"));
    //                }
    //            }
    //            return (T)Convert.ChangeType(value, t);
    //        }
    //        return defaultValue;
    //    }
    //}
    #endregion
}
