﻿namespace Siger.Middlelayer.Common
{
    public class CommonConst
    {
        /// <summary>
        /// 判断设备关机的阈值
        /// </summary>
        public const int MachineShutDownThreshold = 5; // 分钟

        /// <summary>
        /// 刀具计算包络线service
        /// </summary>
        public const string ComputeBlx = "/computeBLX";

        /// <summary>
        /// 极值轮廓线学习
        /// </summary>
        public const string OutLine = "/featureExtractor";

        /// <summary>
        /// 重置标定数据
        /// </summary>
        public const string LabelingConfirm = "/LabelingConfirm";

        /// <summary>
        /// 刀具负载历史记录service
        /// </summary>
        public const string PlotHuandao = "/plotHuandao";

        /// <summary>
        /// DNC中程序物理保存路径
        /// </summary>
        public const string UploadProgramFilePath = "upload/dnc/programs/";
        /// <summary>
        ///ESOP保存路径
        /// </summary>
        public const string EsopProgramFilePath = "image";
        /// <summary>
        ///DFFL保存路径
        /// </summary>
        public const string DfflProgramFilePath = "TemporaryFiles/image/";
        /// <summary>
        /// 从NC端获取程序信息后打包原始文件路径
        /// </summary>
        public const string DownloadProgramFilePath = "download/dnc/programs/";
        /// <summary>
        /// 从NC端获取程序信息后打包zip文件路径
        /// </summary>
        public const string DownloadProgramZIPFilePath = "download/dnc/programs/zip/";

        /// <summary>
        /// 解压压缩包zip 文件路径
        /// </summary>
        public const string DownloadProgramExtractZIPFilePath = "upload/dnc/extractzip/";

        /// <summary>
        /// 压缩包zip 临时存放路径
        /// </summary>
        public const string DownloadProgramTemporaryZIPFilePath = "download/dnc/temporaryzip/";
        /// <summary>
        /// DNC中程序显示路径
        /// </summary>
        public const string DisplayProgramFilePath = "/dnc/programs/";

        /// <summary>
        /// 获取NC程序内容
        /// </summary>
        public const string NCProgram = "/GetProgram";

        /// <summary>
        /// 查询nc端程序修改次数
        /// </summary>
        public const string GetChangeTime = "/GetChangeTime";

        /// <summary>
        /// 上传/下载程序
        /// </summary>
        public const string DownloadProgram = "/DownloadProgram";

        /// <summary>
        /// 上传/下载压缩包程序
        /// </summary>
        public const string DownloadProgramPackage = "/DownloadProgramPackage";

        /// <summary>
        /// 获取机床程序列表
        /// </summary>
        public const string GetProgramList = "/GetProgramList";

        /// <summary>
        /// 删除程序
        /// </summary>
        public const string DeleteProgram = "/DeleteProgram";

        /// <summary>
        /// ACC中打印模板上传路径
        /// </summary>
        public const string UploadLabelFilePath = "upload/acc/LabelFile/";

        /// <summary>
        /// 物料类别最上级编码
        /// </summary>
        public const string MATERIALTYPE_PARENTNAME = "AL";
        /// <summary>
        /// 罗美特追溯附件 存放路径
        /// </summary>
        public const string MetekAttachmentFilePath = "attachment";
    }
}
