﻿using System.ComponentModel;

namespace Siger.Middlelayer.Common
{
    /// <summary>
    /// common error code, start from 1000000
    /// </summary>
    public enum CommonEnum
    {
        [Description("操作失败")]
        Fail = 0,

        [Description("操作成功")]
        Succefull,

        [Description("记录未找到")]
        RecordNotFound = 1000000,

        [Description("获取配置失败")]
        GetCommCfgFailed,

        [Description("获取服务配置失败")]
        GetConsulCfgFailed,

        [Description("未注册License")]
        LicenseIsEmpty,

        [Description("license无效")]
        LicenseIsInvalid,

        [Description("license已过期")]
        LicenseHasExpired,

        [Description("获取主机头失败")]
        GetHostFailed,

        [Description("主机头为空")]
        HostIsEmpty,

        [Description("主机头不合法")]
        HostIsInValid,

        [Description("获取认证信息失败")]
        GetTokenFailed,

        [Description("请求不合法，未找到认证信息")]
        TokenIsEmpty,

        [Description("请求不合法，认证失败")]
        TokenIsInvalid,

        [Description("时间戳未找到")]
        TimeStampIsEmpty,

        [Description("随机数未找到")]
        NonceIsEmpty,

        [Description("签名未找到")]
        SignIsEmpty,

        [Description("签名无效")]
        SignIsInvalid,

        [Description("请求不合法")]
        RequestInValid,

        [Description("登录失败")]
        LoginFailed,

        [Description("记录已存在")]
        RecordExits,

        [Description("自学习选项不能为空")]
        AutoStudyError,

        [Description("是")]
        Yes,

        [Description("否")]
        No,

        [Description("配置失败")]
        ConfigError,

        [Description("测试邮件发送失败")]
        SendMailError,

        [Description("当前运行程序号未配置，换刀失败")]
        ProgramNoNull,

        [Description("CutterLocationID不能为空")]
        CutterLocationIDNotNull,

        [Description("DataNotNull不能为空")]
        DataNotNull,

        [Description("当前搜索条件无程序号")]
        ProgramDataNull,

        [Description("修改失败")]
        UpdateFaild,

        [Description("删除失败")]
        DeleteFaild,

        [Description("审核失败")]
        CheckFaild,

        [Description("审核成功")]
        CheckSuccess,

        [Description("无数据")]
        NoData,

        [Description("仓库名称不能为空")]
        TypeNameNull,

        [Description("父仓库编号不能为空")]
        ParentIDNotNull,

        [Description("仓库类型不存在")]
        StorageTypeIDNotExist,

        [Description("存在底层层级")]
        LayerNotClean,

        [Description("手机端唯一标识未找到")]
        RegistrationIdNotFound,

        [Description("更新用户注册Id失败")]
        UpdateRegistrationIdFailed,

        [Description("没有数据可供导出")]
        NoDataForExport,

        [Description("计划日期小于创建日期")]
        LessBusidate,
        
        [Description("没有该部门权限")]
        NoDepartPermission,

        DontCheckFaild,
        [Description("系统未知异常")]
        SystemExcetion = 9999999,
      
    }

    public enum TemplateNameEnums
    {
        NotFound,
        UserList,
        ProductList,
        MachineList,
        MachineTypeList,
        SparepartTypeList,
        SparepartList,
        ToolsInfo,
        ToolsLocationInfo,
        ToolsChange,
        ProducePlan,
        MaterialTypeInfo,
        MaterialsInfo,
        SerinumCfg,
        BeatAllocation,
        ProductStructureInfo,
        AssemblyMaintenanceInfo,
        DictInfo,
        EquipmentInfo,
        EquipmentPositionInfo,
        RoutingEventNoInfo,
        RoutingOutStationInfo,
        RoutingInStationInfo,
        PackingFullQtyInfo,
        OQCCheckItemInfo,
        WOBookingItemInfo,
        AccCategory,
        Basketf,
        wmscustomerinfo,
        wmsbusinessinfo,
        StorageList,//仓库列表
        FaultType, //Tpm故障类型
        LevelPlanList,
        TechnologyList, //工艺清单
        TechToolList, //刀具清单
        ToolInfoList,//tlm刀具配置
        LevelSection,//产线结构
        RoutingstationInfo,//新页面路由信息导入
        SensorParameter,//传感器台账
        RouteList,
        MachineListSkf,
        KpiItem,
        KpiTaskAct,
        KpiTask,
        LevelPlanListSkf,
        InspectUnhealthyTemplate,
        InspectionStandardList,
        MachineAttribution,
        ReworkSetting, //返工工序维护
        ReworRepairkData,//返工保修 数据
        ReworkWasteData,//返工报废 数据
        ProductStructure, // 产品物料结构清单
        ReworkPositionSetting,
        InspectionStandardMaterialList, //物料检验标准维护
        WorkingGroup,
        AndonExpectionType,//andon expection
        InspectStandardCategoryTemplate,
        InspectStandardItemTemplate,
        ReworkReason,//返工原因
        WorkCellStation,//产品工位信息
        Structure,//制作物料结构
        WorkCell,//工作单元,
        InspectCategoryTemplate,
        ProductAddtion,
        ProductWarehouse,
        TrParameterConfig,
        WorkingCost,//工时费
        //TLM测试项目
        ToollifeDetection,
        ToollifeDetectionCutter,//刀片
        ToollifeDetectionHandler,//刀柄
        ToollifeDetectionAttachment,//附件
        ToollifeDetectionTool,//刀头
        ToollifeToolConfig,
        WorkModeList,//工作模式
        SnRule,//二维码规则
        StorageLocation,
        ProductionPlan,
        //模具
        Mould,//模具导入
        MouldCore,//模芯导入
        MouldDetection,//模具测试项导入
        MouldCoreDetection,//模芯测试项导入
        TechMouldList, //模具清单

    }

    public enum LogLevel
    {
        Info,
        Warn,
        Error,
        Verbose,
        Debug
    }

    public enum Module
    {
        /// <summary>
        /// 网关
        /// </summary>
        Gateway,
        /// <summary>
        /// 基础配置
        /// </summary>
        Config,
        /// <summary>
        /// ACC 追溯服务
        /// </summary>
        Acc,
        /// <summary>
        /// 数字化工厂服务
        /// </summary>
        Cnc,
        /// <summary>
        /// DNC 服务
        /// </summary>
        Dnc,
        /// <summary>
        /// 刀具服务
        /// </summary>
        Tools,
        /// <summary>
        /// 仓库管理系统
        /// </summary>
        Wms,
        /// <summary>
        /// 设备智能管理
        /// </summary>
        Tpm,
        /// <summary>
        /// 刀具流转管理
        /// </summary>
        Tlm,
        /// <summary>
        /// 质量管理系统
        /// </summary>
        Qms,
        /// <summary>
        /// 设备文档管理
        /// </summary>
        Esop,
        /// <summary>
        /// dashboard
        /// </summary>
        Dashboard,
        /// <summary>
        /// ChangLing
        /// </summary>
        ChangLing,
        /// <summary>
        /// GaoBo
        /// </summary>
        GaoBo,
        /// <summary>
        /// Lida
        /// </summary>
        LiDa,
        /// <summary>
        /// JingJin
        /// </summary>
        JingJin,
        /// <summary>
        /// Mobile
        /// </summary>
        Mobile,
        /// <summary>
        /// Sanyi suote
        /// </summary>
        Suote,
        /// <summary>
        /// Fjw
        /// </summary>
        Fjw,
        /// <summary>
        /// KPI
        /// </summary>
        Kpi,
        /// <summary>
        /// 罗美特
        /// </summary>
        LMT,
        /// <summary>
        /// 宁夏共享
        /// </summary>
        NingxiaShared,
        /// <summary>
        /// 模具
        /// </summary>
        IMS,
    }

    public enum LogModule
    {
        BigData = 1,

        MiddleLayer,

        DataAnalysis,

        IoT,
    }

    public enum BigDataModule
    {
        CNC = 0,

        TMS,

        Mould,

        Sensor,

        Ret,

        Public
}

    public enum IoTModule
    {
        Agent,

        DataCenter,

        SmartProxy,

        Daemon
    }

    public enum Personnel
    {
        NoOne,

        Own,

        TheOthers
    }

    public enum Gender
    {
        /// <summary>
        /// 男性
        /// </summary>
        male = 1,

        /// <summary>
        /// 女性
        /// </summary>
        female
    }

    public enum LocationType
    {
        Province,
        City,
        County
    }
    public enum ProgramConfig
    {
        /// <summary>
        /// 已配置程序号
        /// </summary>
        HasConfig = 1,
        /// <summary>
        /// 未配置程序号
        /// </summary>
        NotConfig = 2
    }

    /// <summary>
    /// 1->自用；2->出租；3->出借；4->其他在用；5->停用；6->闲置；7->报废 ；8->盘点中 （当前盘点时的状态）
    /// </summary>
    public enum MachineStatus
    {
        [Description("未知")]
        Unknown,

        [Description("自用")]
        SelfUse,

        [Description("出租")]
        RentOut,

        [Description("出借")]
        Lend,

        [Description("其他在用")]
        OtherUse,

        [Description("停用")]
        Stoped,

        [Description("闲置")]
        Idle,

        [Description("报废")]
        Scrap,

        [Description("盘点中")]
        Inventory
    }
    public enum ProcessProgram
    {
        [Description("未配置")]
        NoConfig = 0,

        [Description("主程序")]
        MainProgram = 1,

        [Description("子程序")]
        ChildProgram
    }

    public enum ISStudy
    {

        /// <summary>
        /// 未学习
        /// </summary>
        UnStudy,
        /// <summary>
        /// 已学习
        /// </summary>
        ISStudy,
    }

    public enum MachineRunningStatus
    {
        [Description("关机")]
        Shutdown,

        [Description("运行")]
        Running,

        [Description("调试")]
        Debugging,

        [Description("空闲")]
        Free,

        [Description("故障")]
        Fault,

        [Description("换线调试")]
        ChangeDebugging
    }

    public enum GaoBoMachineRunningStatus
    {
        [Description("关机")]
        Shutdown,

        [Description("运行")]
        Running,

        [Description("手动调试")]
        Debugging,

        [Description("空闲")]
        Free,

        [Description("故障")]
        Fault,

        [Description("换线调试")]
        LineChange,
    }

    public enum SkfMachineRunningStatus
    {
        [Description("关机")]
        Shutdown,

        [Description("运行")]
        Running,

        [Description("调试")]
        Debugging,

        [Description("空闲")]
        Free,

        [Description("故障")]
        Fault,

        [Description("换线调试")]
        ChangeDebugging,

        [Description("维修中")]
        Repairing,

        [Description("保养/标定中")]
        MaintainSensor,
    }

    public enum SectionType
    {
        [Description("生产部门")] ProduceSection = 1,

        [Description("维修部门")] Maintenance,
    }
    public enum ActionTypeEnum
    {
        /// <summary>
        /// 上传
        /// </summary>
        Upload,
        /// <summary>
        /// 下载
        /// </summary>
        DownLoad,
        /// <summary>
        /// 删除
        /// </summary>
        Delete
    }

    public enum ParameterType
    {
        [Description("主轴转速")]
        AxisSpeed = 1,

        [Description("主轴倍率")]
        AxisRate,

        [Description("进给倍率")]
        FeedRate,
    }

    public enum MachineAttributeType
    {
        Normal = 1,//正常设备
        Serialport,//串口设备
        Ftp,//ftp设备
        NoneSystem//无系统设备
    }
    public enum MachineAttributionEnum
    {
        [Description("设备")]
        equipment = 1,
        [Description("子系统")]
        Subsystem,
        [Description("部件")]
        Parts
    }

    public enum LocationTypeEnum
    {
        WaveHouse,
        Other
    }

    public enum PushMessageResult
    {
        UserAppKeyIsEmpty,
        SendSuccessful,
        PushMessageFailed,
        UserMobileIsEmpty,
        SendSMSFailed,
        ConfigMissing,
        TemplateNotFound,
    }

    public enum LanguageType
    {
        CN,
        EN
    }

    public enum RowState
    {
        /// <summary>
        /// 无效
        /// </summary>
        Invalid = 0,
        /// <summary>
        /// 有效
        /// </summary>
        Valid = 1
    }

    public enum ProductType
    {
        /// <summary>
        /// 成品
        /// </summary>
        InPart = 0,
        /// <summary>
        /// 零件
        /// </summary>
        Part = 1
    }

    public enum TraceType
    {
        /// <summary>
        /// 正常
        /// </summary>
        Normal = 0,
        /// <summary>
        /// 追溯
        /// </summary>
        TraceBack = 1
    }

    public enum UserType
    {
        /// <summary>
        /// 超级管理员
        /// </summary>
        SuperAdmin,

        /// <summary>
        /// 普通用户
        /// </summary>
        User = 1,

        /// <summary>
        /// 管理员
        /// </summary>
        Admin,
    }

    public enum PowerType
    {
        /// <summary>
        /// 网页端
        /// </summary>
        Web = 1,

        /// <summary>
        /// 客户端
        /// </summary>
        Client,

        /// <summary>
        /// 手机端
        /// </summary>
        App,
    }

    public enum XType
    {
        Other=0,
        /// <summary>
        /// 日期
        /// </summary>
        Date ,

        /// <summary>
        /// 产线层级
        /// </summary>
        section,

        /// <summary>
        /// 录入人员
        /// </summary>
        User,
        /// <summary>
        /// 工作模式
        /// </summary>
        WorkMode,
    }

    public enum XTypes
    {
        /// <summary>
        /// 其他
        /// </summary>
        OtherType = 0,
        /// <summary>
        ///  时间
        /// </summary>
        DateType,
        /// <summary>
        /// 产线层级
        /// </summary>
        SectionType,
        /// <summary>
        /// 故障代码
        /// </summary>
        FaultCodeType,
        /// <summary>
        /// 故障类别
        /// </summary>
        FaultType,
        /// <summary>
        /// 时间
        /// </summary>
        DateTypes,
        /// <summary>
        /// 产线层级
        /// </summary>
        SectionTypes,
        /// <summary>
        /// 故障代码
        /// </summary>
        FaultCodeTypes,
        /// <summary>
        /// 工作模式
        /// </summary>
        FaultTypes,
        /// <summary>
        /// 时间
        /// </summary>
        Date,
        /// <summary>
        /// 产线层级
        /// </summary>
        Section,
        /// <summary>
        /// 时间
        /// </summary>
        Dates,
        /// <summary>
        /// 产线层级
        /// </summary>
        Sections,
        /// <summary>
        /// 时间
        /// </summary>
        DateStatus,
        /// <summary>
        /// 产线层级
        /// </summary>
        SectionStatus,
        /// <summary>
        /// 故障代码
        /// </summary>
        FaultCode,
    }
}
