﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace Siger.Middlelayer.Share.Enum.ModuleEnum
{
    public class Automation
    {
        /// <summary>
        /// 任务触发方式 1 手动 2 自动
        /// </summary>
        public enum TaskTrigerType
        {
            /// <summary>
            /// 手动任务
            /// </summary>
            Manual=1,
            /// <summary>
            ///  自动任务
            /// </summary>
            Auto=2
        }
        /// <summary>
        /// Task任务状态结果
        /// </summary>
        public enum TaskResultStatus
        {
            /// <summary>
            /// 取消
            /// </summary>
            Cancel=0,
            /// <summary>
            /// 待生产
            /// </summary>
            Waiting=1,
            /// <summary>
            /// 生产中
            /// </summary>
            Produce=2,
            /// <summary>
            /// 生产完成
            /// </summary>
            Complated=3
        }
        /// <summary>
        /// 设备状态 （自动任务）
        /// </summary>
        public enum MachineStatus
        {
            /// <summary>
            /// 待生产
            /// </summary>
            Waiting = 1,
            /// <summary>
            /// 生产中
            /// </summary>
            Produce = 2,
            /// <summary>
            /// 生产完成
            /// </summary>
            Complated = 3
        }

        /// <summary>
        /// 动作类型 1:load 2:Unload
        /// </summary>
        public enum TaskActionType
        {
            [Description("Load")]
            Load =1,
            [Description("Unload")]
            Unload =2
        }
        /// <summary>
        /// 动作
        /// </summary>
        public enum TaskAction
        {
            /// <summary>
            /// 立库->上下料工站
            /// </summary>
            [Description("立库->上下料位")]
            Step_LK_SXLW=1,
            /// <summary>
            /// 上下料工站->立库
            /// </summary>
            [Description("上下料位->立库")]
            Step_SXLW_LK =2,
            /// <summary>
            /// 立库->加工中心
            /// </summary>
            [Description("立库->加工中心")]
            Step_LK_JGZX =3,
            /// <summary>
            /// 加工中心->清洗机
            /// </summary>
            [Description("加工中心->清洗机")]
            Step_JGZX_QXJ =4,
            /// <summary>
            /// 立库->抽检工位
            /// </summary>
            [Description("立库->抽检台")]
            Step_LK_CJT =5,
            /// <summary>
            /// 抽检工位->上下料工站
            /// </summary>
            [Description("抽检台->上下料位")]
            Step_CJT_SXLW =6,
            /// <summary>
            /// 清洗机->立库
            /// </summary>
            [Description("清洗机->立库")]
            Step_QXJ_LK =7,
            /// <summary>
            /// 加工中心->立库
            /// </summary>
            [Description("加工中心->立库")]
            Step_JGZX_LK =8,
            /// <summary>
            /// 抽检台->立库
            /// </summary>
            [Description("抽检台->立库")]
            Step_CJT_LK = 9,
            /// <summary>
            /// 清洗机->加工中心
            /// </summary>
            [Description("清洗机->加工中心")]
            Step_QXJ_JGZX = 10,
        }
    }
}
