﻿using System;
using System.Collections.Generic;
using System.Text;
using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class RouteList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetCreate]
        public int No { get; set; }

        [ExcelColumn("产品编号")]
        public string ProductCode { get; set; }

        [ExcelColumn("产品图纸号")]
        public string ProductDrawCode { get; set; }

        [ExcelColumn("加工序号")]
        public string RouteNumber { get; set; }

        [ExcelColumn("工序名称")]
        [EmptyValidate("RouteNameIsEmpty")]
        public string RouteName { get; set; }

        [ExcelColumn("工序说明")]
        public string Remark { get; set; }

        //[ExcelColumn("设备类型")]
        //public string MachineType { get; set; }

        [ExcelColumn("额定工时")]
        public double Hours { get; set; }

        [ExcelColumn("准备工时")]
        public string Prepare { get; set; }
    }
}
