﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class wmsbusinessinfo : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int id { get; set; }

        [ExcelColumn("供应商类别*")]
        [EmptyValidate("TypeIsEmpty")]
        public string city { get; set; }
        
        [ExcelColumn("供应商名称*")]
        [EmptyValidate("SupplierNameIsEmpty")]
        public string name { get; set; }

        [ExcelColumn("供应商编号*")]
        [EmptyValidate("lineIsEmpty")]
        public string serial_number { get; set; }

        [ExcelColumn("Duns")]
        public string duns { get; set; }

        [ExcelColumn("公司名称*")]
        [EmptyValidate("CompanyNameIsEmpty")]
        public string enterprise_name { get; set; }

        [ExcelColumn("公司地址*")]
        [EmptyValidate("CompanyAddressIsEmpty")]
        public string address { get; set; }

        [ExcelColumn("联系人*")]
        [EmptyValidate("LinkmanIsEmpty")]
        public string linkman { get; set; }

        [ExcelColumn("电话*")]
        [EmptyValidate("TelephoneIsEmpty")]
        public string phone { get; set; }

        [ExcelColumn("手机*")]
        [EmptyValidate("MobileIsEmpty")]
        public string mobile { get; set; }

        [ExcelColumn("传真")]
        public string fax { get; set; }

        [ExcelColumn("邮箱")]
        public string email { get; set; }

        [ExcelColumn("网址")]
        public string homepage { get; set; }

        [ExcelColumn("是否停用")]
        [DonnetCreate]
        public string status { get; set; }

        [ExcelColumn("备注")]
        public string description { get; set; }
    }
}
