﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class AutomationFixtureToolsAssemblyRepository : AccRepositoryBase<siger_automation_fixture_tools_assembly>, IAutomationFixtureToolsAssemblyRepository
    {
        private ApiAccDbContext _context;
        public AutomationFixtureToolsAssemblyRepository(ApiAccDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseAumationFixtureToolsAssembly> GetPagedList(int category, string code, string name, int projectid, int page, int pagesize)
        {
            var query = from q in _context.siger_automation_fixture_tools_assembly
                        join t1 in _context.siger_automation_fixture_tools on q.parent equals t1.guid into tt1
                        from t1 in tt1.DefaultIfEmpty()
                        join c1 in _context.siger_automation_fixture_tools_category on t1.category equals c1.guid
                        join t2 in _context.siger_automation_fixture_tools on q.son equals t2.guid
                        join c2 in _context.siger_automation_fixture_tools_category on t2.category equals c2.guid
                        join u in _context.siger_project_user on q.updator equals u.mid into uu
                        from u in uu.DefaultIfEmpty()
                        where q.projectId == projectid && string.IsNullOrEmpty(q.parent)
                        select new ResponseAumationFixtureToolsAssembly
                        {
                            id = q.id,
                            parentid = t1 == null ? 0 : t1.id,
                            parentname = t1.name ?? "",
                            fixturetoolid = t2.id,
                            name = t2.name,
                            code = t2.code,
                            partnumber = t2.partnumber,
                            specfication = t2.specification,
                            updator = u.name ?? "",
                            status = q.status,
                            fileurl = q.attachment,
                            filename = q.filename,
                            categoryid = c2.id,
                            category = c2.name,
                            updatetime = q.updatetime.HasValue && q.updatetime > DateTime.MinValue ? q.updatetime.Value.ToString(ParameterConstant.DateTimeFormat) : ""
                        };
            Expression<Func<ResponseAumationFixtureToolsAssembly, bool>> categoryExpression = f => true;
            if (category > 0)
            {
                categoryExpression = q => q.categoryid == category;
            }
            Expression<Func<ResponseAumationFixtureToolsAssembly, bool>> codeExpression = f => true;
            if (!string.IsNullOrEmpty(code))
            {
                categoryExpression = q => q.code.Contains(code);
            }
            Expression<Func<ResponseAumationFixtureToolsAssembly, bool>> nameExpression = f => true;
            if (!string.IsNullOrEmpty(name))
            {
                nameExpression = q => q.name.Contains(name);
            }
            var expression = categoryExpression.And(codeExpression).And(nameExpression);
            var entities = query.Where(expression).OrderByDescending(q => q.id).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            var totalCount = query.Where(expression).Count();
            return new PagedCollectionResult<ResponseAumationFixtureToolsAssembly>(entities, totalCount);
        }

        public IEnumerable<ResponseAumationFixtureToolsAssembly> GetDetailList(int id, int projectid)
        {
            var query = from q in _context.siger_automation_fixture_tools_assembly
                        join t1 in _context.siger_automation_fixture_tools on q.parent equals t1.guid into tt1
                        from t1 in tt1.DefaultIfEmpty()
                        join c1 in _context.siger_automation_fixture_tools_category on t1.category equals c1.guid
                        join t2 in _context.siger_automation_fixture_tools on q.son equals t2.guid
                        join c2 in _context.siger_automation_fixture_tools_category on t2.category equals c2.guid
                        join u in _context.siger_project_user on q.updator equals u.mid into uu
                        from u in uu.DefaultIfEmpty()
                        where q.projectId == projectid && q.id == id
                        select new ResponseAumationFixtureToolsAssembly
                        {
                            id = q.id,
                            parentid = t1 == null ? 0 : t1.id,
                            parentname = t1.name ?? "",
                            fixturetoolid = t2.id,
                            name = t2.name,
                            code = t2.code,
                            partnumber = t2.partnumber,
                            specfication = t2.specification,
                            updator = u.name ?? "",
                            status = q.status,
                            fileurl = q.attachment,
                            filename = q.filename,
                            categoryid = c2.id,
                            category = c2.name,
                            updatetime = q.updatetime.HasValue && q.updatetime > DateTime.MinValue ? q.updatetime.Value.ToString(ParameterConstant.DateTimeFormat) : ""
                        };
            var entities = query.OrderByDescending(q => q.id).AsNoTracking().ToList();
            return entities;
        }
    }
}
