﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class AutomationFixtureToolsCategoryRepository : AccRepositoryBase<siger_automation_fixture_tools_category>, IAutomationFixtureToolsCategoryRepository
    {
        private ApiAccDbContext _context;
        public AutomationFixtureToolsCategoryRepository(ApiAccDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseFixtureToolsCategory> GetPagedList(int id, int projectid, int page, int pagesize)
        {
            Expression<Func<ResponseFixtureToolsCategory, bool>> FunNum = f => true;
            var query = from q in _context.siger_automation_fixture_tools_category
                        join p in _context.siger_automation_fixture_tools_category on q.parent equals p.guid into pp
                        from p in pp.DefaultIfEmpty()
                        where q.projectId == projectid && q.status == (int)RowState.Valid
                        select new ResponseFixtureToolsCategory
                        {
                            id = q.id,
                            name = q.name,
                            parentid = p == null ? 0 : p.id,
                            parentname = p.name ?? "",
                            parent = q.parent,
                            guid = q.guid,
                            createtime = q.createtime.ToString(ParameterConstant.DateTimeFormat),
                            time = q.createtime
                        };
            if (id > 0)
            {
                FunNum = q => q.id == id;
            }
            var entities = query.Where(FunNum).OrderBy(q => q.parentid).OrderBy(q => q.createtime).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            var totalCount = query.Where(FunNum).Count();
            return new PagedCollectionResult<ResponseFixtureToolsCategory>(entities, totalCount);
        }
    }
}
