﻿using System;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class AutomationFixtureToolsProductRepository : AccRepositoryBase<siger_automation_fixture_tools_product>, IAutomationFixtureToolsProductRepository
    {
        private ApiAccDbContext _context;
        public AutomationFixtureToolsProductRepository(ApiAccDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseAumationFixtureToolsProduct> GetPagedList(int category, int tool, int product, int projectid, int page, int pagesize)
        {
            var query = from q in _context.siger_automation_fixture_tools_product
                        join t in _context.siger_automation_fixture_tools on q.fixturetools equals t.guid
                        join c in _context.siger_automation_fixture_tools_category on t.category equals c.guid
                        join p in _context.siger_project_product on q.productid equals p.id
                        join u in _context.siger_project_user on q.updator equals u.mid into uu
                        from u in uu.DefaultIfEmpty()
                        where q.projectId == projectid && q.status == (int)RowState.Valid
                        select new ResponseAumationFixtureToolsProduct
                        {
                            id = q.id,
                            categoryid=c.id,
                            categoryname=c.name,
                            fixturetoolid = t.id,
                            fixturetool = t.name,
                            productid = q.productid,
                            productname = p.name,
                            remark = q.remark,
                            updator = q.updator,
                            updatetime = q.updatetime.HasValue && q.updatetime > DateTime.MinValue ? q.updatetime.Value.ToString(ParameterConstant.DateTimeFormat) : ""
                        };
            Expression<Func<ResponseAumationFixtureToolsProduct, bool>> categoryExpression = f => true;
            if (category > 0)
            {
                categoryExpression = q => q.categoryid == category;
            }
            Expression<Func<ResponseAumationFixtureToolsProduct, bool>> toolExpression = f => true;
            if (tool > 0)
            {
                toolExpression = q => q.fixturetoolid == tool;
            }
            Expression<Func<ResponseAumationFixtureToolsProduct, bool>> productExpression = f => true;
            if (product > 0)
            {
                productExpression = q => q.productid == product;
            }
            var expression = categoryExpression.And(toolExpression).And(productExpression);
            var entities = query.Where(expression).OrderByDescending(q => q.id).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            var totalCount = query.Where(expression).Count();
            return new PagedCollectionResult<ResponseAumationFixtureToolsProduct>(entities, totalCount);
        }
    }
}
