﻿using System;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class AutomationFixtureToolsRepository : AccRepositoryBase<siger_automation_fixture_tools>, IAutomationFixtureToolsRepository
    {
        private ApiAccDbContext _context;
        public AutomationFixtureToolsRepository(ApiAccDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseFixtureTools> GetPagedList(int category, string code, string name, int state, 
                int projectid, int page, int pagesize)
        {
            var query = from q in _context.siger_automation_fixture_tools
                        join p in _context.siger_automation_fixture_tools_category on q.category equals p.guid
                        join u in _context.siger_project_user on q.updator equals u.mid into uu
                        from u in uu.DefaultIfEmpty()
                        where q.projectId == projectid
                        select new ResponseFixtureTools
                        {
                            id = q.id,
                            name = q.name,
                            guid = q.guid,
                            cate_guid = p.guid,
                            categoryid = p.id,
                            category = p.name,
                            managetype = q.managetype,
                            partnumber = q.partnumber,
                            specification = q.specification,
                            number = q.number,
                            remark = q.remark,
                            fileurl = q.attachment ?? "",
                            filename = q.filename ?? "",
                            code = q.code,
                            updator = u.name ?? "",
                            status = q.status,
                            updatetime = q.updatetime.HasValue && q.updatetime > DateTime.MinValue ? q.updatetime.Value.ToString(ParameterConstant.DateTimeFormat) : ""
                        };
            Expression<Func<ResponseFixtureTools, bool>> categoryExpression = f => true;
            if (category > 0)
            {
                categoryExpression = q => q.categoryid == category;
            }
            Expression<Func<ResponseFixtureTools, bool>> codeExpression = f => true;
            if (!string.IsNullOrEmpty(code))
            {
                categoryExpression = q => q.code.Contains(code);
            }
            Expression<Func<ResponseFixtureTools, bool>> nameExpression = f => true;
            if (!string.IsNullOrEmpty(name))
            {
                nameExpression = q => q.name.Contains(name);
            }
            Expression<Func<ResponseFixtureTools, bool>> stateExpression = f => true;
            if (state >= 0)
            {
                stateExpression = q => q.status == state;
            }
            var expression = categoryExpression.And(codeExpression).And(nameExpression).And(stateExpression);
            var entities = query.Where(expression).OrderByDescending(q => q.id).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            var totalCount = query.Where(expression).Count();
            return new PagedCollectionResult<ResponseFixtureTools>(entities, totalCount);
        }
    }
}
