﻿using System;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class AutomationLocationRepository : AccRepositoryBase<siger_automation_location>, IAutomationLocationRepository
    {
        private ApiAccDbContext _context;
        public AutomationLocationRepository(ApiAccDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseAutomationLocation> GetPagedList(int wavehouseid, int locationid, int projectid, int page, int pagesize)
        {
            var query = from q in _context.siger_automation_location
                        join t in _context.siger_automation_fixture_tools on q.fixturetools equals t.guid
                        join c in _context.siger_automation_fixture_tools_category on t.category equals c.guid
                        join l in _context.siger_wms_storage_location on q.locationid equals l.locationid
                        join w in _context.siger_wms_storage on l.storageid equals w.id
                        join m in _context.siger_tr_assist_materials on q.materialid equals m.id
                        join p in _context.siger_project_process on q.processid equals p.id into pp
                        from p in pp.DefaultIfEmpty()
                        join u in _context.siger_project_user on q.updator equals u.mid into uu
                        from u in uu.DefaultIfEmpty()
                        where q.projectId == projectid && q.status == (int)RowState.Valid
                        select new ResponseAutomationLocation
                        {
                            id = q.id,
                            locationid = l.id,
                            location = l.name,
                            wavehouseid = w.id,
                            wavehouse = w.name,
                            fixturetoolid = t.id,
                            fixturetool = t.name,
                            category = c.name,
                            code = t.code,
                            specfication = t.specification,
                            materialid = q.materialid,
                            materialcode = m.pn,
                            processid = q.processid,
                            processnumber = p == null ? 0 : p.Process_Seq,
                            processname = p.Process_name ?? "",
                            materialstate = q.materialstate,
                            fileurl = q.attachment ?? "",
                            filename = q.filename ?? "",
                            remark = q.remark,
                            updator = u.name ?? "",
                            status = q.status,
                            updatetime = q.updatetime.HasValue && q.updatetime > DateTime.MinValue ? q.updatetime.Value.ToString(ParameterConstant.DateTimeFormat) : ""
                        };
            Expression<Func<ResponseAutomationLocation, bool>> wavehouseidExpression = f => true;
            if (wavehouseid > 0)
            {
                wavehouseidExpression = q => q.wavehouseid == wavehouseid;
            }
            Expression<Func<ResponseAutomationLocation, bool>> locationidExpression = f => true;
            if (locationid > 0)
            {
                locationidExpression = q => q.locationid == locationid;
            }
            var expression = wavehouseidExpression.And(locationidExpression);
            var entities = query.Where(expression).OrderByDescending(q => q.id).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            var totalCount = query.Where(expression).Count();
            return new PagedCollectionResult<ResponseAutomationLocation>(entities, totalCount);
        }

        public siger_wms_storage_location GetLocation(int id, int projectid)
        {
            return _context.siger_wms_storage_location.FirstOrDefault(q => q.locationid == id && q.projectId == projectid && q.status == (int)RowState.Valid);
        }
    }
}
