﻿using System.Collections.Generic;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface ISigerBaseSetting : IAccRepositoryBase<SigerTrBaseSetting>
    {
        IEnumerable<SigerTrBaseSetting> GetDataList(int fromline, int toline, int projectid);
        IEnumerable<SigerTrBaseSetting> GetDataBySeq(BaseSettingEnum seq, int projectId, int? station = null);

        /// <summary>
        /// 获取站别功能配置
        /// </summary>
        /// <param name="station"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        IEnumerable<BaseItemSetting> GetBaseItemSettings(int station, int projectId);
    }
}
