﻿using System.Collections.Generic;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface ISigerTrAssemblyMaintenanceRepository : IAccRepositoryBase<SigerTrAssemblyMaintenance>
    {
        CommonImportResult ImportAssemblyMaintenances(IEnumerable<AssemblyMaintenanceTemplate> assemblyMaintenance, int projectid);

        PagedCollectionResult<AssemblyMaintenance> GetPagedList(List<int> stationids, string serial_number, string parent_serial,
            string child_serial, int projectid, int page, int pagesize);

        IEnumerable<AssemblyMaintenance> GetDataList(int lineid, int stationid, string serial_number, string parent_serial,
            string child_serial, int projectid);
    }
}
