﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerBasketSettingRepository: AccRepositoryBase<SigerTrBasketfSetting>, IBasketSettingRepository
    {
        private ApiAccDbContext accDbContext;
        public SigerBasketSettingRepository(ApiAccDbContext apiAccDbContext):base(apiAccDbContext)
        {
            accDbContext = apiAccDbContext;
        }

        public IPagedCollectionResult<BasketSetting> GetTrBasketPagedList(int categoryId,string name, string number, int projectid, int page, int pagesize)
        {
            Expression<Func<BasketSetting, bool>> Funcat = f =>true;
            Expression<Func<BasketSetting, bool>> FuncateId = f => true;
            Expression<Func<BasketSetting, bool>> Funname = f => true;

            var query = from s in accDbContext.siger_tr_basketful_setting
                        join q in accDbContext.siger_tr_basketful_type on s.Type equals q.id
                        into temp
                        from dp in temp.DefaultIfEmpty()
                        where s.projectId == projectid && s.status == (int)RowState.Valid
                        select new BasketSetting
                        {
                             Id=s.id,
                             Name=s.Name,
                             Number=s.Number,
                             Type=dp.Category,
                             TypeId=s.Type,
                             Material=s.Material,
                             Uses=s.Uses,
                             Wide=s.Wide,
                             Hight=s.Hight,
                             Length=s.Length
                        };
            if (!string.IsNullOrEmpty(number))
            {
                Funcat = q => q.Number.Contains(number);
            }
            if (!string.IsNullOrEmpty(name))
            {
                Funname = q => q.Name.Contains(name);
            }
            if (categoryId!=0)
            {
                FuncateId = q => q.TypeId ==categoryId;
            }
            var predicate = Funcat.And(Funname).And(FuncateId);
            var totalCount = query.Count(predicate);
            var entities = query.Where(predicate).OrderByDescending(q => q.Id).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            return new PagedCollectionResult<BasketSetting>(entities, totalCount);

        }

        public CommonImportResult ImportBasketItem(IEnumerable<BasketTemplate> checkitems, int projectid)
        {
            string msg = string.Empty;
            foreach (var obj in checkitems)
            {
                var discr =  obj.Number;
                var exits = accDbContext.siger_tr_basketful_setting.Where(f => f.Type == obj.Type && f.Number==obj.Number);
                if (exits.Any())
                {
                    msg += discr+",";
                    continue;
                }
                accDbContext.siger_tr_basketful_setting.Add(new SigerTrBasketfSetting {
                     Type=obj.Type,
                     Number=obj.Number,
                     Name=obj.Name,
                     Material=obj.Material,
                     Uses=obj.Uses,
                     projectId=projectid,
                     Wide=obj.Wide,
                     Hight=obj.Hight,
                     Length=obj.Length,
                     status=1
                });

            }
            accDbContext.SaveChanges();
            int ret = 1;
            if (!string.IsNullOrEmpty(msg))
            {
                var translateHelper = new TranslateHelper(GetProjectLanguage(projectid) == (int) LanguageType.EN);
                msg += translateHelper.GetTranslateText(TranslateEnEnum.Existing);
                ret = 0;
            }
            return new CommonImportResult(ret, msg);
         
        }
    }
}
