﻿using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerPositionRepository : AccRepositoryBase<SigerTrPosition>, IPositionRepository
    {
        private readonly ApiAccDbContext accDbContext;
        public SigerPositionRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public List<siger_project_level> GetUserProjectLevel(int projectid)
        {
            var query = accDbContext.siger_project_level.Where(t => t.projectid == projectid && t.status == (int)RowState.Valid);
            return query.ToList();
        }

        public List<siger_project_level_section> GetLevelSections(int projectid, int levelid)
        {
            var query = accDbContext.siger_project_level_section.Where(t => t.projectid == projectid && t.status == (int)RowState.Valid && t.levelid == levelid);
            return query.ToList();
        }
    }
}
