﻿using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.AccRepository.Request
{
    public class RequestCheckItem
    {
        [Required(ErrorMessage = "ProductIDIsEmpty")]
        public string ProductID { get; set; }
        [Required(ErrorMessage = "PNeIsEmpty")]
        public string PN { get; set; }
        [Required(ErrorMessage = "LineIsEmpty")]
        public int Line { get; set; }
        [Required(ErrorMessage = "StationIsEmpty")]
        public int Station { get; set; }
        public int Seq { get; set; }
        [Required(ErrorMessage = "ItemIsEmpty")]
        public string Item { get; set; }
        public string Descr { get; set; }
        [Required(ErrorMessage = "CheckTypeIsEmpty")]
        public string CheckType { get; set; }
        public string Min { get; set; }
        public string Max { get; set; }
        /// <summary>
        /// 工艺路由
        /// </summary>
        public int Route { get; set; }
    }

    public class RequestUpdateCheckItem : RequestCheckItem
    {
        [Required(ErrorMessage = "IdIsEmpty")]
        public string Id { get; set; }
    }
}
