﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository.Request;

namespace Siger.Middlelayer.AccRepository.Request
{
    public class RequestAddFixtureToolsCategory
    {
        public string parentid { get; set; }

        public string name { get; set; }
    }

    public class RequestUpdateFixtureToolsCategory : RequestAddFixtureToolsCategory
    {
        public int id { get; set; }
    }

    public class RequestDeleteRange
    {
        public List<int> ids { get; set; } = new List<int>();
    }


    public class RequestAddFixtureTools
    {
        /// <summary>
        /// 工装类别
        /// </summary>
        public string categoryid { get; set; }
        /// <summary>
        /// 管理类型
        /// </summary>
        public string managetype { get; set; }
        /// <summary>
        /// 工装料号
        /// </summary>
        public string partnumber { get; set; }
        /// <summary>
        /// 工装名称
        /// </summary>
        public string name { get; set; }
        /// <summary>
        /// 规格型号
        /// </summary>
        public string specifition { get; set; }
        /// <summary>
        /// 数量
        /// </summary>
        public string number { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }
        /// <summary>
        /// 附件
        /// </summary>
        public string fileurl { get; set; }
        public string filename { get; set; }
        /// <summary>
        /// 工装编号
        /// </summary>
        public string code { get; set; }

        public string status { get; set; }
    }

    public class RequestUpdateFixtureTools : RequestAddFixtureTools
    { 
        public int id { get; set; }
    }


    public class RequestAddFixtureToolsProduct
    {
        /// <summary>
        /// 工装ID
        /// </summary>
        public string fixturetoolid { get; set; }
        /// <summary>
        /// 产品ID
        /// </summary>
        public string productid { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }
    }

    public class RequestUpdateFixtureToolsProduct : RequestAddFixtureToolsProduct
    {
        public int id { get; set; }
    }



    public class RequestAddAutomationLocation
    {
        /// <summary>
        /// 储位位置
        /// </summary>
        public string locationid { get; set; }
        /// <summary>
        /// 工装ID
        /// </summary>
        public string fixturetoolid { get; set; }
        /// <summary>
        /// 物料ID
        /// </summary>
        public string materialid { get; set; }
        /// <summary>
        /// 工序ID
        /// </summary>
        public string processid { get; set; }
        /// <summary>
        /// 附件
        /// </summary>
        public string fileurl { get; set; }
        public string filename { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }
    }

    public class RequestUpdateAutomationLocation : RequestAddAutomationLocation
    {
        public int id { get; set; }
    }

    public class RequestAddFixtureToolAssembly
    {
        public string parentid { get; set; }
        public string fixturetoolid { get; set; }
        public string fileurl { get; set; }
        public string filename { get; set; }

        public string status { get; set; }
    }

    public class RequestUpdateFixtureToolAssembly : RequestAddFixtureToolAssembly
    {
        public int id { get; set; }
    }
}
