﻿using System.Collections.Generic;

namespace Siger.Middlelayer.AccRepository.Response
{
    public class ResponsePowerSection
    {
        public int Id { get; set; }
        public string Title { get; set; }
        public List<ResponsePowerSection> PowerSections { get; set; }

    }
    public class ResponseMenus
    {
        public int id { get; set; }

        /// <summary>
        /// 权限描述
        /// </summary>
        public string description { get; set; }

        /// <summary>
        /// 父级权限id
        /// </summary>
        public string parent { get; set; }

        /// <summary>
        /// 排序字段
        /// </summary>
        public int sorting { get; set; } = 0;

        public string icon { get; set; } = string.Empty;
        /// <summary>
        /// 页面类型：1->网页 2->程序 3->app
        /// </summary>
        public int type { get; set; }

        public List<ResponseMenus> children { get; set; }

        /// <summary>
        /// 添加子级
        /// </summary>
        public void Add(ResponseMenus child)
        {
            if (children == null)
            {
                children = new List<ResponseMenus>();
            }
            children.Add(child);
        }
        #region 前端字段
        public string title { get; set; }
        public bool spread { get; set; } = true;
        public bool disabled { get; set; }
        #endregion
    }
}

