﻿using System.Collections.Generic;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.CncRepository.Repositories.Interface
{
    public interface IProductPlanRepository : ICncRepositoryBase<siger_project_product_plan>
    {
        IPagedCollectionResult<ResponseGetProducesReport> GetPagedProductReport(string product_name,
            string draw_number, string code, IEnumerable<int> machinearr,
            int projectId, int startTime, int endTime, string ordernumber, string work_code, string state, int page, int pagesize);
        IPagedCollectionResult<ResponseGetProductPlan> GetPagedProductPlan(string product_name, string draw_number,
            string code, string ordernumber, string status,int ordertype, int startTime, int endTime, string isdelay, int projectId, int page, int pagesize);

        CommonImportResult ImportProducePlan(IEnumerable<ProducePlanList> plans, int projectId);

        CommonImportResult ImportXuGongProducePlan(IEnumerable<ProducePlanList> plans, int projectId);

        IEnumerable<siger_project_product_plan> GetNoPagedProductPlan(string product_name, string draw_number,
            string code, string status, int projectId);

        IEnumerable<ResponseAllPassProductReport> GetAllPassProductReports(int sectionid, long startDate, long endDate, string code, int userId, int projectId,int approve);

        IPagedCollectionResult<ResponseGetProductNoPlan> GetPagedProductNoPlan(string product_name, 
            string code, string startTime, string endTime, int projectId, int page, int pagesize);
        IEnumerable<QualificationRate> GetAllPassProductReports(int sectionid, long startDate, long endDate, int projectId);
        #region 生产计划管理
        IPagedCollectionResult<ResponseGetProductPlanManage> GetPagedProductPlanManage(string product_name, string draw_number,
           string code, string ordernumber, int status, int startTime, int endTime, int isdelay, int projectId,int delaystart ,int delayend, int page, int pagesize);
        #endregion
        IPagedCollectionResult<ResponsePlanExecutionAnalysis> GetAllPlanDetails(int sectionid, int productid, int starttime, int endtime, int projectId, int page, int pagesize);
        ResponsePlanSum GetAllPlanSum(int sectionid, int productid, int starttime, int endtime, int projectId);
        CommonImportResult ImportProductionPlan(IEnumerable<ProductionPlanList> plans, int projectId);
        ResponseUserReport GetReportDetails(int userId, int projectId);
    }
}
