﻿using System;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.CncRepository.Repositories
{
    internal class SigerProjectPlanChangeRepository : CncRepositoryBase<siger_project_product_plan_change>, ISigerProjectPlanChangeRepository
    {
        private readonly ApiCncDbContext _context;
        public SigerProjectPlanChangeRepository(ApiCncDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponsePlanChange> GetPlanChanges(string code, string product_name, string startTime, string endTime, int projectid,int page, int pagesize)
        {
            var queryList = from q in _context.siger_project_product_plan_change
                join p in _context.siger_project_product_plan on q.plan_id equals p.id
                where q.project_id == projectid && q.status == (int) RowState.Valid
                select new ResponsePlanChange
                {
                    id = q.id,
                    product_name = p.product_name,
                    product_code = p.product_code,
                    draw_code = p.draw_number,
                    delivery_date = p.delivery_time,
                    quantity = p.quantity,
                    code = p.ordernumber,
                    change_content = p.ordernumber + " --> " + q.new_code,
                    approval_status = q.approval_status,
                    create_time = q.create_time
                };

            Expression<Func<ResponsePlanChange, bool>> codeExpression = q => true;
            if (!string.IsNullOrEmpty(code))
            {
                codeExpression = q => q.change_content.Contains(code);
            }
            Expression<Func<ResponsePlanChange, bool>> productnameExpression = q => true;
            if (!string.IsNullOrEmpty(product_name))
            {
                productnameExpression = q => q.product_name.Contains(product_name);
            }
            Expression<Func<ResponsePlanChange, bool>> startExpression = q => true;
            if (!string.IsNullOrEmpty(startTime))
            {
                startExpression = q => q.create_time >= DateTime.Parse(startTime);
            }
            Expression<Func<ResponsePlanChange, bool>> endExpression = q => true;
            if (!string.IsNullOrEmpty(endTime))
            {
                endExpression = q => q.create_time <= DateTime.Parse(endTime).AddDays(1);
            }
            var predicate = codeExpression.And(productnameExpression).And(startExpression).And(endExpression);

            var totalCount = queryList.Count(predicate);
            var entities = queryList.Where(predicate).OrderBy(q => q.approval_status)
                .ThenByDescending(q => q.create_time).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();

            return new PagedCollectionResult<ResponsePlanChange>(entities, totalCount);
        } 
    }
}
