﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;

namespace Siger.Middlelayer.CncRepository.Repositories
{
    internal class SigerWoTraceRepository : CncRepositoryBase<siger_project_wo_trace>, ISigerWoTraceRepository
    {
        private readonly ApiCncDbContext _context;
        public SigerWoTraceRepository(ApiCncDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<WoTraceReportInfo> GetWoTraceReports(int projectId, string productId, int line, int station, string wo, int mid, DateTime beginTime, DateTime endTime, int page, int pageSize)
        {
            Expression<Func<siger_project_wo_trace, bool>> FunProductId = q => true;
            Expression<Func<siger_project_wo_trace, bool>> FunLine = q => true;
            Expression<Func<siger_project_wo_trace, bool>> FunStation = q => true;
            Expression<Func<siger_project_wo_trace, bool>> FunWo = q => true;
            Expression<Func<siger_project_wo_trace, bool>> FunMid = q => true;

            if (!string.IsNullOrEmpty(productId))
                FunProductId = f => f.ProductID == productId;
            if (line != 0)
                FunLine = f => f.Line == line;
            if (station != 0)
                FunStation = f => f.Station == station;
            if (!string.IsNullOrEmpty(wo))
                FunWo = f => f.WO == wo;
            if (mid != 0)
                FunMid = f => f.UID == mid;
            var predicate = FunProductId.And(FunLine).And(FunStation).And(FunWo).And(FunMid);

            var queryList = from t in _context.siger_tr_wo_trace.Where(predicate)
                            join l in _context.siger_project_level_section on t.Line equals l.id
                            join s in _context.siger_project_level_section on t.Station equals s.id
                            join u in _context.siger_project_user on t.UID equals u.mid
                            join p in _context.siger_project_product on t.ProductID equals p.code
                            join pl in _context.siger_project_product_plan_detail on t.WO equals pl.orderNumber
                            join sch in _context.siger_project_produce_schedule on pl.id equals sch.plandetail_id
                            where t.projectId == projectId && t.TransDateTime >= beginTime && t.TransDateTime <= endTime
                            select new WoTraceReportInfo
                            {

                                Id = t.id,
                                TraceId = t.SeqID,
                                Line = l.title,
                                Station = s.title,
                                Wo = t.WO,
                                ProductId = t.ProductID,
                                ProductName = p.name,
                                DrawCode = p.drawingcode,
                                Route = sch.route_name,
                                OkCount = t.OkCount,
                                NgCount = t.NgCount,
                                NgCount2 = t.NgCount2,
                                Type = t.Type,
                                Result = t.Result,
                                Time = t.TransDateTime,
                                User = u.name,
                                DebugCount = t.DebugCount
                            };


            var totalCount = queryList.Count();
            var result = queryList.OrderByDescending(d => d.Id).Skip((page - 1) * pageSize).Take(pageSize).AsNoTracking().ToList();
            foreach (var r in result)
            {
                var wotype = (WoType)r.Type;
                r.Operate = EnumHelper.GetEnumDesc(wotype);


            }
            return new PagedCollectionResult<WoTraceReportInfo>(result, totalCount);
        }

        public IEnumerable<WoTraceReportInfo> ExportWoTraceReports(int projectId, string productId, int line, int station, string wo, int mid, DateTime beginTime, DateTime endTime)
        {
            Expression<Func<siger_project_wo_trace, bool>> FunProductId = q => true;
            Expression<Func<siger_project_wo_trace, bool>> FunLine = q => true;
            Expression<Func<siger_project_wo_trace, bool>> FunStation = q => true;
            Expression<Func<siger_project_wo_trace, bool>> FunWo = q => true;
            Expression<Func<siger_project_wo_trace, bool>> FunMid = q => true;

            if (!string.IsNullOrEmpty(productId))
                FunProductId = f => f.ProductID == productId;
            if (line != 0)
                FunLine = f => f.Line == line;
            if (station != 0)
                FunStation = f => f.Station == station;
            if (!string.IsNullOrEmpty(wo))
                FunWo = f => f.WO == wo;
            if (mid != 0)
                FunMid = f => f.UID == mid;
            var predicate = FunProductId.And(FunLine).And(FunStation).And(FunWo).And(FunMid);

            var queryList = from t in _context.siger_tr_wo_trace.Where(predicate)
                            join d in _context.siger_tr_wo_trace_detail on t.SeqID equals d.SeqID
                            join l in _context.siger_project_level_section on t.Line equals l.id
                            join s in _context.siger_project_level_section on t.Station equals s.id
                            join u in _context.siger_project_user on t.UID equals u.mid
                            join p in _context.siger_project_product on t.ProductID equals p.code
                            join pl in _context.siger_project_product_plan_detail on t.WO equals pl.orderNumber
                            join sch in _context.siger_project_produce_schedule on pl.id equals sch.plandetail_id
                            where t.projectId == projectId && t.TransDateTime >= beginTime && t.TransDateTime <= endTime
                            select new WoTraceReportInfo
                            {

                                Id = t.id,
                                TraceId = t.SeqID,
                                Line = l.title,
                                Station = s.title,
                                Wo = t.WO,
                                ProductId = t.ProductID,
                                ProductName = p.name,
                                DrawCode = p.drawingcode,
                                Route = sch.route_name,
                                OkCount = t.OkCount,
                                NgCount = t.NgCount,
                                NgCount2 = t.NgCount2,
                                Type = t.Type,
                                Result = t.Result,
                                Time = t.TransDateTime,
                                User = u.name,
                                DebugCount = t.DebugCount,
                                Item=d.Item,
                                Value=d.Value
                            };
            var totalCount = queryList.Count();
            var result = queryList.OrderByDescending(d => d.Id).AsNoTracking().ToList();
            foreach (var r in result)
            {
                var wotype = (WoType)r.Type;
                r.Operate = EnumHelper.GetEnumDesc(wotype);
            }
            return result;

        }
    }
}
