﻿using System;
using System.Reflection;
using Microsoft.Extensions.DependencyInjection;
using Siger.Middlelayer.AccRepository;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.CncRepository;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.DashboardRepository.Repositories;
using Siger.Middlelayer.DashboardRepository.Repositories.Interface;
using Siger.Middlelayer.EsopRepository;
using Siger.Middlelayer.EsopRepository.Repositories.Interface;
using Siger.Middlelayer.KpiRespository;
using Siger.Middlelayer.KpiRespository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.TlmRepository;
using Siger.Middlelayer.TlmRepository.Repositories.Interface;
using Siger.Middlelayer.TpmRepository;
using Siger.Middlelayer.TpmRepository.Repositories.Interface;
using Siger.Middlelayer.WmsRepository;
using Siger.Middlelayer.WmsRepository.Repositories.Interface;

namespace Siger.Middlelayer.DashboardRepository
{
    public class DashboardRepositoryFactory
    {
        private static DashboardRepositoryFactory _factory;

        public static DashboardRepositoryFactory Instance => _factory ?? (_factory = new DashboardRepositoryFactory());

        public void Initialization(IServiceCollection services)
        {
            DiRepositories(services, typeof(IDashboardRepositoryBase<>));
            RepositoryFactory.Instance.DiRepositories(services, typeof(IApiConfigRepositoryBase<>));
            CncRepositoryFactory.Instance.DiRepositories(services, typeof(ICncRepositoryBase<>));
            TpmRepositoryFactory.Instance.DiRepositories(services, typeof(ITpmRepositoryBase<>));
            QmsRepositoryFactory.Instance.DiRepositories(services, typeof(IQmsRepositoryBase<>));
            KpiRepositoryFactory.Instance.DiRepositories(services, typeof(ISigerKpiBase<>));
            AccRepositoryFactory.Instance.DiRepositories(services, typeof(IAccRepositoryBase<>));
            EsopRepositoryFactory.Instance.DiRepositories(services, typeof(IEsopRepositoryBase<>));
            TlmRepositoryFactory.Instance.DiRepositories(services, typeof(ITlmRepositoryBase<>));
            WmsRepositoryFactory.Instance.DiRepositories(services, typeof(IWMSRepositoryBase<>));
            services.AddDbContext<ApiConfigDbContext>();
            services.AddDbContext<ApiCncDbContext>();
            services.AddDbContext<ApiDashboardDbContext>();
            services.AddDbContext<ApiTpmDbContext>();
            services.AddDbContext<ApiQmsDbContext>();
            services.AddDbContext<ApiKpiDbContext>();
            services.AddDbContext<ApiAccDbContext>();
            services.AddDbContext<ApiEsopDbContext>();
            services.AddDbContext<ApiTlmDbContext>();
            services.AddDbContext<ApiWmsDbContext>();
            services.AddScoped(typeof(IUnitOfWork), typeof(DashboardUnitOfWork));
        }

        private void DiRepositories(IServiceCollection services, Type moduleType)
        {
            foreach (Type type in Assembly.Load(GetType().Assembly.GetName()).GetTypes())
            {
                if (typeof(IRepository).IsAssignableFrom(type) && type.IsClass && !type.IsAbstract)
                {
                    var interfaces = type.GetInterfaces();
                    foreach (var i in interfaces)
                    {
                        if (!i.IsGenericType && i != typeof(IRepositoryBase<>)
                                             && i != typeof(IRepository)
                                             && i.Name != moduleType.Name)
                        {
                            services.AddScoped(i, type);
                        }
                    }
                }
            }
        }
    }
}
