﻿using System;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.IMSRepository.Entities;
using Siger.Middlelayer.IMSRepository.Repositories.Interface;
using Siger.Middlelayer.IMSRepository.Response;

namespace Siger.Middlelayer.IMSRepository.Repositories
{
    internal class ToolLifeToolGrindRepository : IMSRepositoryBase<siger_project_ims_tool_grind>, IToolLifeToolGrindRepository
    {
        private readonly ApiIMSDbContext _context;
        public ToolLifeToolGrindRepository(ApiIMSDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseGetToolGrind> GetPagedList(int material_id, int status, int starttime, int endtime, 
            int page, int pagesize, int projectId, int toexcel)
        {
            var querylist = from q in _context.siger_project_ims_tool_grind
                            join t in _context.siger_project_ims_tool on q.material_id equals t.material_id
                            join m in _context.siger_tr_materials on q.material_id equals m.id
                            join b in _context.siger_wms_bussinese_contacts on q.supplier_id equals b.id into bb
                            from b in bb.DefaultIfEmpty()
                            where q.status != (int)RowState.Invalid && q.project_id == projectId &&
                                  t.status == (int)RowState.Valid && t.project_id == projectId
                            select new ResponseGetToolGrind
                            {
                                id = q.id,
                                serial_number = q.stock_number,
                                material_name = m.name ?? "",
                                remain_times = q.remain_times,
                                recycling_time = UnixTimeHelper.ConvertIntDateTime(q.recycling_time),
                                apply_time = UnixTimeHelper.ConvertIntDateTime(q.apply_time),
                                grind_time = UnixTimeHelper.ConvertIntDateTime(q.grind_time),
                                grind_type = t.grind_type > 0 ? t.grind_type : 0,
                                status = q.status,
                                part_no = q.part_no,
                                ctime = q.recycling_time,
                                material_id = q.material_id,
                                supplier_id = q.supplier_id,
                                supplier = b.name ?? "",
                                manage_mode = m.manage_mode,
                                businessID = q.supplier_id,
                            };
            Expression<Func<ResponseGetToolGrind, bool>> statusExpression = q => true;
            if (status != 0)
            {
                statusExpression = q => q.status == status;
            }
            Expression<Func<ResponseGetToolGrind, bool>> timeExpression = q => true;
            if (starttime > 0 && endtime>0)
            {
                timeExpression = q => (q.ctime <= endtime && q.ctime >= starttime);
            }
            Expression<Func<ResponseGetToolGrind, bool>> partNoExpression = q => true;
            if (material_id>0)
            {
                partNoExpression = q => q.material_id == material_id;
            }

            var predicate = statusExpression.And(timeExpression).And(partNoExpression);

            if (toexcel == 0)
            {
                var totalCount = querylist.Count(predicate);
                var entities = querylist.Where(predicate).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
                return new PagedCollectionResult<ResponseGetToolGrind>(entities, totalCount);
            }
            else
            {
                var entities = querylist.Where(predicate).AsNoTracking().ToList();
                return new PagedCollectionResult<ResponseGetToolGrind>(entities, 0);
            }
        }
    }
}
