﻿using Siger.Middlelayer.KpiRespository.Entities;
using Siger.Middlelayer.KpiRespository.Repositories.Interface;
using Siger.Middlelayer.KpiRespository.Respose;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Siger.Middlelayer.Common;
using System.Linq.Expressions;

namespace Siger.Middlelayer.KpiRespository.Repositories
{
    internal class KpiItemDisplayPosition : KpiRepositoryBase<SigerProjectKpiItemDisplayPosition>, ISigerKpiItemDisplayPosition
    {
        private ApiKpiDbContext _kpiDbContext;
        public KpiItemDisplayPosition(ApiKpiDbContext context) : base(context)
        {
            _kpiDbContext = context;
        }

        public IEnumerable<ResponseItemDisplay> GetItemDisplayPosition(int section, int projectId)
        {
            Expression<Func<ResponseItemDisplay, bool>> FunSection = f => true;
            var query = from p in _kpiDbContext.siger_project_kpi_item_display_position
                        join i in _kpiDbContext.siger_project_kpi_item on p.Item equals i.id
                        join s in _kpiDbContext.siger_project_section on  i.Section  equals s.id 
                        join s1 in _kpiDbContext.siger_project_section on p.Section equals s1.id
                        where p.projectId == projectId && p.status==(int)RowState.Valid  && p.Section==section
                        
                        select new ResponseItemDisplay
                        {
                            Id=p.id,
                            ItemId=p.Item,
                            ItemDesc=i.Item,
                            ItemSection=i.Section,
                            ItemSectionDesc=s.title,
                            Section=p.Section,
                            SectionDesc=s1.title,
                            Position=p.Position,
                            Cycle=i.KpiCycle,
                            Color=p.Color
                        };
            if (section != 0)
                FunSection = f => f.Section == section;
            var result = query.GroupBy(t => t.Id).Select(s=>s.FirstOrDefault());
            return result;
            
        }
    }
}
