﻿using Siger.Middlelayer.KpiRespository.Request;
using Siger.Middlelayer.Share.ModuleEnum;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.KpiRespository.Respose
{
    public class ResponsePushSetting
    {

        public string ProcessCode { get; set; }
        public int Id { get; set; }
        /// <summary>
        /// 部门Id
        /// </summary>
        public int DepartId { get; set; }
        public string Depart { get; set; }
        public int KpiItemId { get; set; }
        public string KpiItem { get; set; }
        public int Refresh { get; set; }
        public string FlowDetails { get; set; }
        public string User { get; set; }
        public DateTime DateTime { get; set; }
        public string Remarks { get; set; }
        public ReponsePushErroTypeLevel Level1 { get; set; }
        public ReponsePushErroTypeLevel Level2 { get; set; }
        public ReponsePushErroTypeLevel Level3 { get; set; }
        public ReponsePushErroTypeLevel Level4 { get; set; }
    }
    public class ReponsePushErroTypeLevel
    {
        public ReponsePushErroTypeLevel()
        {
            Sections = new ReponseUserGroup();
        }
        /// <summary>
        /// 类型1: 未指定负责人
        /// </summary>
        public ReponsePushErroType Type1 { get; set; }
        /// <summary>
        /// 类型2:未处理完成
        /// </summary>
        public ReponsePushErroType Type2 { get; set; }
        /// <summary>
        /// 类型3: 异常解除
        /// </summary>
        public ReponsePushErroType Type3 { get; set; }
        /// <summary>
        /// 职位
        /// </summary>
        public ReponseUserGroup Sections { get; set; }

    }
    public class ReponsePushErroType
    {
        ///// <summary>
        ///// 等级上报时间
        ///// </summary>
        public int Min { get; set; }
        ///// <summary>
        ///// 上报分类
        ///// </summary>
        public KpiPushSettingType Type { get; set; }
    }
    public class ReponseUserGroup
    {
        public List<int> usergroup { get; set; }
        public List<string> groupname { get; set; }
    }
}
