﻿using System;
using System.Collections.Generic;
using OfficeOpenXml.FormulaParsing.Excel.Functions.DateTime;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.QmsRepository.Repositories.Interface
{
    public interface IInspectStandardRepository : IQmsRepositoryBase<siger_qms_inspection_standard>
    {
        IPagedCollectionResult<RepsonseInspectStandard> GetPagedList(int productid, List<int> sectionid, int projectId, int page, int pagesize);

        IEnumerable<RepsonseInspectStandard> GetDataList(int productid, List<int> sectionid, int projectId);

        CommonImportResult ImportInspectionStandard(IEnumerable<InspectionStandardLevelTemplate> standards, int levelCount, int projectid, int userid, 
            Dictionary<string, int> categories);

        RepsonseInspectStandard GetData(int id, int projectId);

        /// <summary>
        /// 获取追溯数据分页
        /// </summary>
        /// <param name="productCode">产品Code</param>
        /// <param name="projectId">项目ID</param>
        /// <param name="itemIds">检验项 ids</param>
        /// <param name="begin">开始时间</param>
        /// <param name="end">结束时间</param>
        /// <param name="page">页面</param>
        /// <param name="pagesize">显示页数</param>
        /// <returns></returns>
        IPagedCollectionResult<ResponseTraceDts> GetTraceDtsByItemPagedList(string productCode,  int projectId, List<int> itemIds, DateTime begin, DateTime end, int page, int pagesize);

        /// <summary>
        /// 获取追溯明细
        /// </summary>
        /// <param name="productCode"></param>
        /// <param name="projectId"></param>
        /// <param name="snlst"></param>
        /// <param name="itemIds"></param>
        /// <param name="begin"></param>
        /// <param name="end"></param>
        /// <returns></returns>
        IEnumerable<ResponseTraceDts> GetTraceDtsByItem(string productCode, int projectId,List<string>snlst, List<int> itemIds, DateTime begin, DateTime end);

        IEnumerable<ResponseBiheadRoute> GetSectionItem(int projectId, int yItem, List<int> itemIds);

        /// <summary>
        /// 获取检验项
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="productId"></param>
        /// <param name="stations"></param>
        /// <param name="valueType"></param>
        /// <returns></returns>
        IEnumerable<ResponseIdItem> GetSectionValueTypeItem(int projectId, int productId, List<int>stations,int valueType=0);

        IEnumerable<ResponseTraceDts> GetTraceDtsValByItem(string productCode, int projectId, List<int> itemIds, DateTime begin, DateTime end);
    }
}
