﻿using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Siger.Middlelayer.Common;
using System.Linq.Expressions;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Utility.ImportEntities;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.QmsRepository.Repositories
{
    internal class QmsProductAddtionRepository : QMSRepositoryBase<siger_qms_product_addition>, IQmsProductAddtion
    {
        private ApiQmsDbContext qmsDbContext;
        public QmsProductAddtionRepository(ApiQmsDbContext context) : base(context)
        {
            qmsDbContext = context;
        }

        public IPagedCollectionResult<ResponseProductAddtion> GetAddtionPagedList(int sectionid, string productCode, string productName, int projectId, int page, int pagesize)
        {
            Expression<Func<ResponseProductAddtion, bool>> funCode = f => true;
            Expression<Func<ResponseProductAddtion, bool>> funName = f => true;
            Expression<Func<ResponseProductAddtion, bool>> funsectionid = f => true;
            var query = from a in qmsDbContext.siger_qms_product_addition
                       join p in qmsDbContext.siger_project_product on a.productid equals p.id
                       join q in qmsDbContext.siger_project_level_section on a.sectionid equals q.id
                       where a.projectid == projectId && a.status == (int)RowState.Valid && q.status== (int)RowState.Valid
                        select new ResponseProductAddtion
                       {
                            Id=a.id,
                            AddVal=a.addval,
                            ProductId=p.id,
                            ProductCode=p.code,
                            ProductName=p.name,
                            sectionid=a.sectionid,
                            sectoindesc =q.title
                       };

            if (!string.IsNullOrEmpty(productCode))
                funCode = f => f.ProductCode.Contains(productCode);
            if (!string.IsNullOrEmpty(productName))
                funName = f => f.ProductName.Contains(productName);
            if (sectionid > 0)
                funsectionid = f => f.sectionid == sectionid;
            var predicate = funCode.And(funName).And(funsectionid);
            var total = query.Count(predicate);
            var entities = query.Where(predicate).OrderBy(s => s.Id).Skip((page - 1) * pagesize).Take(pagesize).ToList();
            return new PagedCollectionResult<ResponseProductAddtion>(entities, total);
        }

        public CommonImportResult ImportAddtion(IEnumerable<ImportProductAddtion> datas, int projectid)
        {
            int rowIndex = 0;
            List<string> messages = new List<string>();
            List<siger_qms_product_addition> entities = new List<siger_qms_product_addition>();
            foreach (var it in datas)
            {
                rowIndex += 1;

                var productObj = qmsDbContext.siger_project_product.FirstOrDefault(f => f.projectid == projectid && f.code == it.ProductCode);
                if (productObj==null)
                {
                    messages.Add($"{rowIndex},{(int)RequestEnum.ProductCodeIsNull}");
                    return new CommonImportResult(0, string.Join(";", messages));
                }
                var section = qmsDbContext.siger_project_level_section.FirstOrDefault(f => f.projectid == projectid && f.status == (int)RowState.Valid && f.title == it.section);
                if (section == null)
                {
                    messages.Add($"{rowIndex},{(int)RequestEnum.PassagewayError}");
                    return new CommonImportResult(0, string.Join(";", messages));
                }
                var obj = qmsDbContext.siger_qms_product_addition.FirstOrDefault(f => f.projectid == projectid && f.productid == productObj.id && f.sectionid==section.id);
                if (obj != null)
                {
                    messages.Add($"{rowIndex},{(int)CommonEnum.RecordExits}");
                    return new CommonImportResult(0, string.Join(";", messages));
                }
                
                entities.Add(new siger_qms_product_addition
                {
                   projectid=projectid,
                   productid=productObj.id,
                   sectionid=section.id,
                   addval=it.Val,
                    status = (int)RowState.Valid,
                });
            }
            try
            {
                qmsDbContext.siger_qms_product_addition.AddRange(entities);
                if (qmsDbContext.SaveChanges() > 0)
                    return new CommonImportResult(1, "1");
                else
                    throw new BadRequestException(CommonEnum.Fail);
            }
            catch
            {
                throw;
            }
        }
    }
}
