﻿using System.Collections.Generic;

namespace Siger.Middlelayer.QmsRepository.Response
{
    public class RepsonseCountNumber
    {
        public string productname { get; set; }

        public string line { get; set; }

        public string station { get; set;}

        /// <summary>
        /// 制表时间
        /// </summary>
        public string tabulation_time { get; set; }

        /// <summary>
        /// 时间范围
        /// </summary>
        public string time_limit { get; set; }

        /// <summary>
        /// 总数量
        /// </summary>
        public int total { get; set; } = 0;

        /// <summary>
        /// 总不良数
        /// </summary>
        public int total_unhealthy { get; set; } = 0;

        public double total_unhealthy_rate { get; set; } = 0;

        public List<CountTable> datalist { get; set; } = new List<CountTable>();

        public List<string> x { get; set; } = new List<string>();

        public List<object> y { get; set; } = new List<object>();

        public List<object> y_rate { get; set; } = new List<object>();
    }

    public class CountTable
    {
        public string group { get; set; }

        /// <summary>
        /// 总数
        /// </summary>
        public int total_number { get; set; } = 0;

        /// <summary>
        /// 不良代码
        /// </summary>
        public string unhealthy_code { get; set; }

        public string unhealthy_desc { get; set; }

        public int unhealthy_number { get; set; } = 0;

        public double unhealthy_rate { get; set; }
    }

    public class ResponseCountValue
    {
        public string productname { get; set; }

        /// <summary>
        /// 制表时间
        /// </summary>
        public string tabulation_time { get; set; }

        /// <summary>
        /// 时间范围
        /// </summary>
        public string time_limit { get; set; }

        /// <summary>
        /// 总组数/总样本
        /// </summary>
        public string total { get; set; }

        /// <summary>
        /// 检验项目
        /// </summary>
        public string item { get; set; }

        /// <summary>
        /// 检验单位
        /// </summary>
        public string unit { get; set; }

        /// <summary>
        /// 规格上限
        /// </summary>
        public double usl { get; set; }

        /// <summary>
        /// 规格下限
        /// </summary>
        public double lsl { get; set; }

        /// <summary>
        /// 规格中心
        /// </summary>
        public double sl { get; set; }

        /// <summary>
        /// xbar控制图的控制上限
        /// </summary>
        public double xucl { get; set; }

        /// <summary>
        /// R控制图的控制上限
        /// </summary>
        public double rucl { get; set; }

        /// <summary>
        /// 平均数管制下限
        /// </summary>
        public double xlcl { get; set; }

        /// <summary>
        /// xbar控制图的控制下限
        /// </summary>
        public double rlcl { get; set; }

        /// <summary>
        /// R控制图的中心值
        /// </summary>
        public double xbar { get; set; }

        /// <summary>
        /// R控制图的中心值
        /// </summary>
        public double rbar { get; set; }

        /// <summary>
        /// 准确度(偏移度)
        /// </summary>
        public double ca { get; set; }

        /// <summary>
        /// 精密度(离散度)
        /// </summary>
        public double cp { get; set; }

        /// <summary>
        /// 制程能力指数
        /// </summary>
        public double cpk { get; set; }

        /// <summary>
        /// 组距
        /// </summary>
        public double class_width { get; set; }

        /// <summary>
        /// 标准差水准
        /// </summary>
        public double std_level { get; set; }

        public List<string> x { get; set; } = new List<string>();

        public List<object> y { get; set; } = new List<object>();

        public List<double> y_xchart { get; set; } = new List<double>();

        public List<double> y_rchart { get; set; } = new List<double>();

        public List<CountValueTable> datalist { get; set; } = new List<CountValueTable>();
    }

    public class CountValueTable
    {
        public string group { get; set; }

        /// <summary>
        /// 平均数
        /// </summary>
        public double mean { get; set; }

        /// <summary>
        /// 极差
        /// </summary>
        public double range { get; set; }

        /// <summary>
        /// 样本
        /// </summary>
        public List<double> sample { get; set; } = new List<double>();

        /// <summary>
        /// 单值
        /// </summary>
        public double single { get; set; }

        /// <summary>
        /// 移动值
        /// </summary>
        public double move { get; set; }

        /// <summary>
        /// 组上限
        /// </summary>
        public double upper { get; set; }

        /// <summary>
        /// 组下限
        /// </summary>
        public double lower { get; set; }

        /// <summary>
        /// 次数
        /// </summary>
        public int number { get; set; }
    }

    public class SpcAnalysisResult
    {
        /// <summary>
        /// 均值
        /// </summary>
        public double Xbar { get; set; } = 0;

        /// <summary>
        /// R均值
        /// </summary>
        public double Rbar { get; set; } = 0;

        /// <summary>
        /// 平均数控制图中心线
        /// </summary>
        public double XCL { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public double A2 { get; set; } = 0;

        /// <summary>
        /// 控制上限
        /// </summary>
        public double XUCL { get; set; } = 0;

        /// <summary>
        /// 控制下限
        /// </summary>
        public double XLCL { get; set; } = 0;

        /// <summary>
        /// 极差控制图中心线
        /// </summary>
        public double RCL { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public double D4 { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public double D3 { get; set; } = 0;

        /// <summary>
        /// 控制上限
        /// </summary>
        public double RUCL { get; set; } = 0;

        /// <summary>
        /// 控制下限
        /// </summary>
        public double RLCL { get; set; } = 0;

        /// <summary>
        /// 规格上限
        /// </summary>
        public double USL { get; set; } = 0;

        /// <summary>
        /// 规格下限
        /// </summary>
        public double LSL { get; set; } = 0;

        /// <summary>
        /// 规格公差
        /// </summary>
        public double T { get; set; } = 0;

        /// <summary>
        /// 标准差
        /// </summary>
        public double Sigma { get; set; } = 0;

        /// <summary>
        /// R标准差
        /// </summary>
        public double Rsigma { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public double Cpu { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public double Cpl { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public double Cp { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public double Ca { get; set; } = 0;

        /// <summary>
        /// 规格中心
        /// </summary>
        public double SL { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public double Cpk { get; set; } = 0;

        /// <summary>
        /// 组数
        /// </summary>
        public double K { get; set; } = 0;

        /// <summary>
        /// 组距
        /// </summary>
        public double CW { get; set; } = 0;

        public double GroupMin { get; set; }

        public double GroupMax { get; set; }
    }
}
