﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Repository.Data
{
    public class SpindleTrueInfo
    {
        /// <summary>
        /// 自增ID
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// 数采spinlde 的ID
        /// </summary>
        public string Spindle { get; set; }
        /// <summary>
        /// 关联设备ID
        /// </summary>
        public int Equipid { get; set; }
        public List<CutterLocationTrueInfo> CutterLocations { get; set; }
    }
    /// <summary>
    /// 刀位表
    /// </summary>
    public class CutterLocationTrueInfo
    {
        public int Id { get; set; }
        /// <summary>
        /// 刀位名称/编号
        /// </summary>
        public string  Name { get; set; }
        /// <summary>
        /// 刀具 ID
        /// </summary>
        public int? ToolId { get; set; }
        /// <summary>
        /// 程序号
        /// </summary>
        public string ProgramNo { get; set; }
        /// <summary>
        /// 子程序
        /// </summary>
        public string SubProgramNo { get; set; }
        /// <summary>
        /// 程序号类型：1-主程序 2-子程序（无任何意义）
        /// </summary>
        public int? ProgramType { get; set; }
        /// <summary>
        /// 当前的加工程序是： 0 未配置 / 1-主程序 2-子程序  
        /// </summary>
        public int? IsProcess { get; set; }
        /// <summary>
        /// 额定寿命
        /// </summary>
        public int? Ratedlife { get; set; }

        /// <summary>
        /// 自动学习控制线
        /// </summary>
        public int? AutoStudy { get; set; }

        /// <summary>
        /// 关联production id
        /// </summary>
        public int Productid { get; set; }

    }
}
