﻿using Siger.Middlelayer.Repository.Entities;
using System.Collections.Generic;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface IApiConfigRepositoryBase<TEntity> : IRepositoryBase<TEntity> where TEntity : ConfigEntityBase
    {
        int GetProjectLanguage(int projectId);
        string GetLineLevelTitlebByMachine(int machine, int projectId);

        string GetMachineLocationBySectionId(int sectionId, int projectId);
        string GetMachineLocationByMachineId(int machineId, int projectId);
        IEnumerable<siger_project_machine_attribution> GetSonLevelMachineAttribution(int parentId, int projectid);

        string GetUserNamesByMids(string mids, int projectId);
    }
}