﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Request;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerProjectUserGroupRepository : IApiConfigRepositoryBase<siger_project_usergroup>
    {
        IPagedCollectionResult<UserGroupItem> GetUserGroupItems(int id, int projectid, int page, int pagesize);

        UserGroupItem GetUserGroupItem(int id, int projectid);

        AddUserGroupKeysEnum AddUserGroupKeys(int usergroupid, int projectid, IList<UserGroupKeys> userGroupKeys);

        IEnumerable<UserGroupTree> GetProjectUserTreeBySectionId(int sectionid, int projectid);

        IEnumerable<UserGroupTitle> GetGroupsUsers(int groupid);

        IEnumerable<siger_project_user_group> GetUser_GroupsByMid(int mid);

        IEnumerable<siger_project_user_group> GetUser_GroupsByGroupId(int groupid);

        int AddUser_Group(IEnumerable<int> mids, int groupid);

        int DeleteUser_Group(int mid, int groupid);

        int DeleteUser_GroupByGroupId(int groupId);

        IEnumerable<UserGroupSectionInfo> GetGroupSectionInfos(int projectId);

        IEnumerable<int> GetGroupSectionIds(int userId, int projectId);
    }
}
