﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.Repository.Repositories
{
    internal class MachineDocumentRepository : ApiConfigRepositoryBase<siger_project_machine_documentmanagement>, IMachineDocumentRepository
    {
        private readonly ApiConfigDbContext _context;
        public MachineDocumentRepository(ApiConfigDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseGetMachineDocumentList> GetPagedList(IEnumerable<int> machineIds, 
            int docType, int machineLife, string docName, int startTime, int endTime, int projectId, int page, int pagesize)
        {
            var query = from q in _context.siger_project_machine_documentmanagement
                join u in _context.siger_project_user on q.create_mid equals u.mid
                where q.status == (int)RowState.Valid && q.projectid == projectId
                select new ResponseGetMachineDocumentList
                {
                    id = q.id,
                    amount = q.amount,
                    doc_name = q.title,
                    doc_type = q.type,
                    machine_life = q.machine_life,
                    remark = q.remark,
                    url = q.url,
                    user_name = u.name,
                    machine_id = q.machineid,
                    machineType_id = q.machinetypeid,
                    create_time = q.create_time
                };

            Expression<Func<ResponseGetMachineDocumentList, bool>> machineExpression = q => true;
            if (machineIds.Any())
            {
                machineExpression = q => machineIds.Contains(q.machine_id);
            }
            Expression<Func<ResponseGetMachineDocumentList, bool>> docTypeExpression = q => true;
            if (docType != 0)
            {
                docTypeExpression = q => q.doc_type == docType;
            }
            Expression<Func<ResponseGetMachineDocumentList, bool>> machineLifeExpression = q => true;
            if (machineLife != 0)
            {
                machineLifeExpression = q => q.machine_life == machineLife;
            }
            Expression<Func<ResponseGetMachineDocumentList, bool>> docNameExpression = q => true;
            if (!string.IsNullOrWhiteSpace(docName))
            {
                docNameExpression = q => q.doc_name.Contains(docName);
            }
            Expression<Func<ResponseGetMachineDocumentList, bool>> timeExpression = q => true;
            if (startTime > 0 && endTime > 0)
            {
                timeExpression = q => q.create_time >= startTime && q.create_time <= endTime;
            }
            var predicate = machineExpression.And(docTypeExpression).And(machineLifeExpression)
                .And(docNameExpression).And(timeExpression);

            var totalCount = query.Count(predicate);
            var entities = query.Where(predicate).OrderByDescending(q => q.create_time).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            return new PagedCollectionResult<ResponseGetMachineDocumentList>(entities, totalCount);
        }
    }
}
