﻿using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Response;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Siger.Middlelayer.Repository.Repositories
{
    internal class MonthReportConfigTemplateRepository : ApiConfigRepositoryBase<siger_project_monthreport_config_template>, IMonthReportConfigTemplateRepository
    {
        private readonly ApiConfigDbContext _context;
        public MonthReportConfigTemplateRepository(ApiConfigDbContext context) : base(context)
        {
            _context = context;
        }

        public IEnumerable<ResponseMachineGroup> GetDashboardMachineGroup(int projectId)
        {

            var grouplst = _context.siger_project_dashboard_machine_group.Where(f => f.projectid == projectId && f.status == (int)RowState.Valid).ToList();
            var result = new List<ResponseMachineGroup>();
            //foreach(var group in grouplst)
            //{
            //    var machineGrp = new ResponseMachineGroup
            //    {
            //         GroupId=group.id,
            //         Title=group.group,
            //         Machines=new List<MachineGroup>()
            //    };
            //    List<int> machines = group.machineid.Split(',').Select(t => t.ToInt());
            //    foreach (var m in machines)
            //    {
            //        var machineSection = _context.siger_project_level_section.FirstOrDefault(f => f.id == m);
            //        if (machineSection == null)
            //            continue;
            //        machineGrp.Machines.Add(new MachineGroup
            //        {
            //            machineId = machineSection.id,
            //            Title = machineSection.title
            //        });

            //    }
            //    result.Add(machineGrp);
            //}
            return result;
        }
        public List<ResponseIdName> GetMachineGroup(int projectId, List<int> ids)
        {
            var query = _context.siger_project_dashboard_machine_group.Where(f => f.projectid == projectId && ids.Contains(f.id) && f.status == (int)RowState.Valid);
            var result = new List<ResponseIdName>();

            foreach (var q in query)
            {
                result.Add(new ResponseIdName
                {
                    id = q.id,
                    name = q.group
                });
            }
            return result;
        }

    }
}
